/*
 * Decompiled with CFR 0.152.
 */
package com.themastergeneral.ctdcore.helpers;

import java.text.NumberFormat;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;

public class ModUtils {
    public static MutableComponent displayString(String string) {
        return Component.literal((String)string);
    }

    public static MutableComponent displayTranslation(String string) {
        return Component.translatable((String)string);
    }

    public static String returnShortenedNumber(Number number) {
        Long numberLong = number.longValue();
        NumberFormat nf = NumberFormat.getInstance();
        Object returned = numberLong < 1000L ? nf.format(number) : (numberLong < 1000000L ? nf.format(numberLong / 1000L) + "K" : (numberLong < 1000000000L ? nf.format(numberLong / 1000000L) + "M" : (numberLong < 1000000000000L ? nf.format(numberLong / 1000000000L) + "B" : (numberLong < 1000000000000000L ? nf.format(numberLong / 1000000000000L) + "T" : (numberLong < 1000000000000000000L ? nf.format(numberLong / 1000000000000000L) + " Q" : nf.format(number))))));
        return returned;
    }

    public static String returnFormattedNumber(Number number) {
        return NumberFormat.getInstance().format(number);
    }

    public static String getLoader() {
        return "NeoForge";
    }

    public static String getLoaderVersion() {
        String version = FMLLoader.class.getPackage().getImplementationVersion();
        return version != null ? version : "Unknown";
    }

    @NotNull
    public static String getMCVersion() {
        return SharedConstants.getCurrentVersion().name();
    }

    public static String createProgressBar(int current, int max) {
        return ModUtils.createProgressBar(current, max, 30);
    }

    public static String createProgressBar(int current, int max, int maxLength) {
        int barLength = Math.min(max, maxLength);
        int progress = (int)((double)current / (double)max * (double)barLength);
        StringBuilder bar = new StringBuilder();
        bar.append("\u00a7r[");
        for (int i = 0; i < barLength; ++i) {
            if (i < progress) {
                bar.append("\u00a72|");
                continue;
            }
            bar.append("\u00a74#");
        }
        bar.append("\u00a7r]");
        return bar.toString();
    }
}

