/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.util;

import com.google.common.io.CharSource;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentParser {
    private final BufferedReader reader;

    private char read() throws IOException {
        int c = this.reader.read();
        if (c == -1) {
            throw new EOFException("End of stream reached unexpectedly!");
        }
        return (char)c;
    }

    public Map<String, String> parse() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        while (this.reader.ready()) {
            KeyValue entry = this.parseLine();
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public KeyValue parseLine() throws IOException {
        String key = this.parseKey();
        String value = this.parseValue();
        try {
            this.reader.mark(1);
            char newline = this.read();
            if (newline == '\r') {
                this.reader.mark(1);
                if (this.read() != '\n') {
                    throw new IOException("Expected CRLF but only got CR");
                }
                this.reader.reset();
            } else if (newline != '\n') {
                this.reader.reset();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new KeyValue(key, value);
    }

    private String parseKey() throws IOException {
        StringBuilder buffer = new StringBuilder();
        while (true) {
            char c = this.read();
            switch (c) {
                case '\n': 
                case '\r': 
                case '=': {
                    return buffer.toString();
                }
            }
            buffer.append(c);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseValue() throws IOException {
        StringBuilder buffer = new StringBuilder();
        try {
            block7: while (true) {
                char c = this.read();
                switch (c) {
                    case '\n': 
                    case '\r': {
                        return buffer.toString();
                    }
                    case '\"': {
                        buffer.append(this.parseQuotedPhrase());
                        continue block7;
                    }
                    case '\\': {
                        char next = this.read();
                        buffer.append(next);
                        continue block7;
                    }
                }
                buffer.append(c);
            }
        }
        catch (EOFException e) {
            return buffer.toString();
        }
    }

    private String parseQuotedPhrase() throws IOException {
        StringBuilder buffer = new StringBuilder();
        block4: while (true) {
            char c = this.read();
            switch (c) {
                case '\"': {
                    return buffer.toString();
                }
                case '\\': {
                    char next = this.read();
                    buffer.append(next);
                    continue block4;
                }
            }
            buffer.append(c);
        }
    }

    public static Map<String, String> parse(File target) throws IOException {
        CharSource charSource = Files.asCharSource(target, StandardCharsets.UTF_8);
        EnvironmentParser parser = new EnvironmentParser(charSource.openBufferedStream());
        return parser.parse();
    }

    public EnvironmentParser(BufferedReader reader) {
        this.reader = reader;
    }

    private static class KeyValue {
        private final String key;
        private final String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KeyValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "EnvironmentParser.KeyValue(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

