/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.util;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class LocaleEncodingControl
extends ResourceBundle.Control {
    private static final Logger log = Logger.getLogger(LocaleEncodingControl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (!format.equals("java.properties")) {
            return super.newBundle(baseName, locale, format, loader, reload);
        }
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, "properties");
        InputStream is = this.getResourceAsStream(resourceName, loader, reload);
        if (is == null) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        bis.mark(3);
        byte[] buf = new byte[3];
        this.readFully(bis, buf);
        boolean isUtf8 = buf[0] == -17 && buf[1] == -69 && buf[2] == -65;
        bis.reset();
        if (isUtf8) {
            log.info("Found UTF-8 locale file " + resourceName);
        }
        Charset charset = isUtf8 ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        try (InputStreamReader reader = new InputStreamReader((InputStream)bis, charset);){
            PropertyResourceBundle bundle = new PropertyResourceBundle(reader);
            ((Reader)reader).close();
            PropertyResourceBundle propertyResourceBundle = bundle;
            return propertyResourceBundle;
        }
    }

    private InputStream getResourceAsStream(String resourceName, ClassLoader loader, boolean reload) throws IOException {
        URLConnection conn;
        URL url;
        if (reload && (url = loader.getResource(resourceName)) != null && (conn = url.openConnection()) != null) {
            conn.setUseCaches(false);
            return conn.getInputStream();
        }
        return loader.getResourceAsStream(resourceName);
    }

    private void readFully(InputStream is, byte[] buf) throws IOException {
        int n;
        int offset = 0;
        for (int length = buf.length; length > 0; length -= n) {
            n = is.read(buf, offset, length);
            if (n == -1) {
                throw new EOFException();
            }
            offset += n;
        }
    }
}

