/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.auth;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.skcraft.launcher.auth.AuthenticationException;
import com.skcraft.launcher.auth.LoginService;
import com.skcraft.launcher.auth.SavedSession;
import com.skcraft.launcher.auth.Session;
import com.skcraft.launcher.auth.UserType;
import com.skcraft.launcher.util.HttpRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class YggdrasilLoginService
implements LoginService {
    private final URL authUrl;
    private final String clientId;

    public Session login(String id, String password) throws IOException, InterruptedException, AuthenticationException {
        AuthenticatePayload payload = new AuthenticatePayload(new Agent("Minecraft"), id, password, this.clientId);
        return this.call(this.authUrl, payload, null);
    }

    @Override
    public Session restore(SavedSession savedSession) throws IOException, InterruptedException, AuthenticationException {
        RefreshPayload payload = new RefreshPayload(savedSession.getAccessToken(), this.clientId);
        return this.call(new URL(this.authUrl, "/refresh"), payload, savedSession);
    }

    private Session call(URL url, Object payload, SavedSession previous) throws IOException, InterruptedException, AuthenticationException {
        HttpRequest req = HttpRequest.post(url).bodyJson(payload).execute();
        if (req.getResponseCode() != 200) {
            ErrorResponse error = req.returnContent().asJson(ErrorResponse.class);
            throw new AuthenticationException(error.getErrorMessage(), true);
        }
        AuthenticateResponse response = req.returnContent().asJson(AuthenticateResponse.class);
        Profile profile = response.getSelectedProfile();
        if (profile == null) {
            return null;
        }
        if (previous != null && previous.getAvatarImage() != null) {
            profile.setAvatarImage(previous.getAvatarImage());
        }
        return profile;
    }

    public YggdrasilLoginService(URL authUrl, String clientId) {
        this.authUrl = authUrl;
        this.clientId = clientId;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Profile
    implements Session {
        @JsonProperty(value="id")
        private String uuid;
        private String name;
        private boolean legacy;
        private byte[] avatarImage;
        @JsonIgnore
        private final Map<String, String> userProperties = Collections.emptyMap();
        @JsonBackReference
        private AuthenticateResponse response;

        @Override
        @JsonIgnore
        public String getSessionToken() {
            return String.format("token:%s:%s", this.getAccessToken(), this.getUuid());
        }

        @Override
        @JsonIgnore
        public String getAccessToken() {
            return this.response.getAccessToken();
        }

        @Override
        @JsonIgnore
        public UserType getUserType() {
            return this.legacy ? UserType.LEGACY : UserType.MOJANG;
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public String getUuid() {
            return this.uuid;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean isLegacy() {
            return this.legacy;
        }

        @Override
        public byte[] getAvatarImage() {
            return this.avatarImage;
        }

        @Override
        public Map<String, String> getUserProperties() {
            return this.userProperties;
        }

        public AuthenticateResponse getResponse() {
            return this.response;
        }

        @JsonProperty(value="id")
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLegacy(boolean legacy) {
            this.legacy = legacy;
        }

        public void setAvatarImage(byte[] avatarImage) {
            this.avatarImage = avatarImage;
        }

        public void setResponse(AuthenticateResponse response) {
            this.response = response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isLegacy() != other.isLegacy()) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (!Arrays.equals(this.getAvatarImage(), other.getAvatarImage())) {
                return false;
            }
            Map<String, String> this$userProperties = this.getUserProperties();
            Map<String, String> other$userProperties = other.getUserProperties();
            if (this$userProperties == null ? other$userProperties != null : !((Object)this$userProperties).equals(other$userProperties)) {
                return false;
            }
            AuthenticateResponse this$response = this.getResponse();
            AuthenticateResponse other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isLegacy() ? 79 : 97);
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + Arrays.hashCode(this.getAvatarImage());
            Map<String, String> $userProperties = this.getUserProperties();
            result = result * 59 + ($userProperties == null ? 43 : ((Object)$userProperties).hashCode());
            AuthenticateResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            return result;
        }

        public String toString() {
            return "YggdrasilLoginService.Profile(uuid=" + this.getUuid() + ", name=" + this.getName() + ", legacy=" + this.isLegacy() + ", avatarImage=" + Arrays.toString(this.getAvatarImage()) + ", userProperties=" + this.getUserProperties() + ")";
        }
    }

    private static class ErrorResponse {
        private String error;
        private String errorMessage;
        private String cause;

        public String getError() {
            return this.error;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getCause() {
            return this.cause;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void setCause(String cause) {
            this.cause = cause;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse other = (ErrorResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
                return false;
            }
            String this$cause = this.getCause();
            String other$cause = other.getCause();
            return !(this$cause == null ? other$cause != null : !this$cause.equals(other$cause));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            String $cause = this.getCause();
            result = result * 59 + ($cause == null ? 43 : $cause.hashCode());
            return result;
        }

        public String toString() {
            return "YggdrasilLoginService.ErrorResponse(error=" + this.getError() + ", errorMessage=" + this.getErrorMessage() + ", cause=" + this.getCause() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AuthenticateResponse {
        private String accessToken;
        private String clientToken;
        @JsonManagedReference
        private Profile selectedProfile;

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public Profile getSelectedProfile() {
            return this.selectedProfile;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public void setSelectedProfile(Profile selectedProfile) {
            this.selectedProfile = selectedProfile;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthenticateResponse)) {
                return false;
            }
            AuthenticateResponse other = (AuthenticateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$clientToken = this.getClientToken();
            String other$clientToken = other.getClientToken();
            if (this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken)) {
                return false;
            }
            Profile this$selectedProfile = this.getSelectedProfile();
            Profile other$selectedProfile = other.getSelectedProfile();
            return !(this$selectedProfile == null ? other$selectedProfile != null : !((Object)this$selectedProfile).equals(other$selectedProfile));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthenticateResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $clientToken = this.getClientToken();
            result = result * 59 + ($clientToken == null ? 43 : $clientToken.hashCode());
            Profile $selectedProfile = this.getSelectedProfile();
            result = result * 59 + ($selectedProfile == null ? 43 : ((Object)$selectedProfile).hashCode());
            return result;
        }

        public String toString() {
            return "YggdrasilLoginService.AuthenticateResponse(accessToken=" + this.getAccessToken() + ", clientToken=" + this.getClientToken() + ", selectedProfile=" + this.getSelectedProfile() + ")";
        }
    }

    private static class RefreshPayload {
        private final String accessToken;
        private final String clientToken;
        private boolean requestUser = true;

        public RefreshPayload(String accessToken, String clientToken) {
            this.accessToken = accessToken;
            this.clientToken = clientToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public boolean isRequestUser() {
            return this.requestUser;
        }

        public void setRequestUser(boolean requestUser) {
            this.requestUser = requestUser;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshPayload)) {
                return false;
            }
            RefreshPayload other = (RefreshPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequestUser() != other.isRequestUser()) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$clientToken = this.getClientToken();
            String other$clientToken = other.getClientToken();
            return !(this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefreshPayload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequestUser() ? 79 : 97);
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $clientToken = this.getClientToken();
            result = result * 59 + ($clientToken == null ? 43 : $clientToken.hashCode());
            return result;
        }

        public String toString() {
            return "YggdrasilLoginService.RefreshPayload(accessToken=" + this.getAccessToken() + ", clientToken=" + this.getClientToken() + ", requestUser=" + this.isRequestUser() + ")";
        }
    }

    private static class AuthenticatePayload {
        private final Agent agent;
        private final String username;
        private final String password;
        private final String clientToken;

        public AuthenticatePayload(Agent agent, String username, String password, String clientToken) {
            this.agent = agent;
            this.username = username;
            this.password = password;
            this.clientToken = clientToken;
        }

        public Agent getAgent() {
            return this.agent;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthenticatePayload)) {
                return false;
            }
            AuthenticatePayload other = (AuthenticatePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Agent this$agent = this.getAgent();
            Agent other$agent = other.getAgent();
            if (this$agent == null ? other$agent != null : !((Object)this$agent).equals(other$agent)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$clientToken = this.getClientToken();
            String other$clientToken = other.getClientToken();
            return !(this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthenticatePayload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Agent $agent = this.getAgent();
            result = result * 59 + ($agent == null ? 43 : ((Object)$agent).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $clientToken = this.getClientToken();
            result = result * 59 + ($clientToken == null ? 43 : $clientToken.hashCode());
            return result;
        }

        public String toString() {
            return "YggdrasilLoginService.AuthenticatePayload(agent=" + this.getAgent() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", clientToken=" + this.getClientToken() + ")";
        }
    }

    private static class Agent {
        private final String name;
        private final int version = 1;

        public Agent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Agent)) {
                return false;
            }
            Agent other = (Agent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Agent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "YggdrasilLoginService.Agent(name=" + this.getName() + ", version=" + this.getVersion() + ")";
        }
    }
}

