/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import com.skcraft.launcher.swing.TextFieldPopupMenu;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class DirectoryField
extends JPanel {
    private static final long serialVersionUID = 5706210803738919578L;
    private final JTextField textField;
    private final JButton browseButton;

    public DirectoryField() {
        this.setLayout(new BoxLayout(this, 0));
        this.textField = new JTextField(30);
        this.textField.setMaximumSize(this.textField.getPreferredSize());
        this.add(this.textField);
        this.add(Box.createHorizontalStrut(3));
        this.browseButton = new JButton("Browse...");
        this.browseButton.setPreferredSize(new Dimension(this.browseButton.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.add(this.browseButton);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryField.this.browse();
            }
        });
        this.textField.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }

    public void setPath(String path) {
        this.getTextField().setText(path);
    }

    public String getPath() {
        return this.getTextField().getText();
    }

    protected JFileChooser getFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select folder");
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directories";
            }
        });
        return chooser;
    }

    public void browse() {
        JFileChooser chooser = this.getFileChooser();
        File f = new File(this.getPath());
        if (f.exists() && f.isFile()) {
            f = f.getParentFile();
        }
        chooser.setCurrentDirectory(f);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.setPath(chooser.getSelectedFile().getPath());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTextField().setEnabled(enabled);
        this.getBrowseButton().setEnabled(enabled);
    }
}

