/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.google.common.io.ByteSource;
import com.google.common.io.Closer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;

public class ZipExtract
implements Runnable {
    private final ByteSource source;
    private final File destination;
    private List<String> exclude;

    public ZipExtract(@NonNull ByteSource source, @NonNull File destination) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.source = source;
        this.destination = destination;
    }

    @Override
    public void run() {
        Closer closer = Closer.create();
        try {
            ZipEntry entry;
            InputStream is = closer.register(this.source.openBufferedStream());
            ZipInputStream zis = closer.register(new ZipInputStream(is));
            this.destination.getParentFile().mkdirs();
            while ((entry = zis.getNextEntry()) != null) {
                if (!this.matches(entry)) continue;
                File file = new File(this.getDestination(), entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                this.writeEntry(zis, file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean matches(ZipEntry entry) {
        if (this.exclude != null) {
            for (String pattern : this.exclude) {
                if (!entry.getName().startsWith(pattern)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntry(ZipInputStream zis, File path) throws IOException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            path.getParentFile().mkdirs();
            fos = new FileOutputStream(path);
            bos = new BufferedOutputStream(fos);
            IOUtils.copy((InputStream)zis, (OutputStream)bos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(bos);
        IOUtils.closeQuietly(fos);
    }

    public String toString() {
        return this.destination.getName();
    }

    public ByteSource getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }
}

