/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.transaction;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.neoforged.neoforge.transfer.transaction.TransactionManager;
import org.jetbrains.annotations.Nullable;

public final class Transaction
implements AutoCloseable,
TransactionContext {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    Lifecycle lifecycle = Lifecycle.NONE;
    private final TransactionManager manager;
    private final int depth;
    private final List<SnapshotJournal<?>> journalsToClose = new ArrayList();
    private final Class<?> callerClass;

    public static Transaction open(@Nullable TransactionContext parent) {
        return TransactionManager.getManagerForThread().open(parent, STACK_WALKER.getCallerClass());
    }

    public static Lifecycle getLifecycle() {
        TransactionManager manager = TransactionManager.getManagerForThread();
        return manager.currentDepth == -1 ? Lifecycle.NONE : manager.stack.get(manager.currentDepth).lifecycle();
    }

    public static boolean hasActiveTransaction() {
        return Transaction.getLifecycle().isActive();
    }

    @Deprecated
    @Nullable
    public static TransactionContext getCurrentOpenedTransaction() {
        TransactionManager manager = TransactionManager.getManagerForThread();
        if (manager.currentDepth == -1) {
            return null;
        }
        Transaction transaction = manager.stack.get(manager.currentDepth);
        if (transaction.lifecycle.isOpen()) {
            return transaction;
        }
        throw new IllegalStateException("`getCurrentOpenedTransaction()` cannot be called while a transaction is closing.");
    }

    public void commit() {
        this.close(Result.COMMITTED);
    }

    @Override
    public void close() {
        if (this.manager.isOpen() && this.lifecycle.isOpen()) {
            this.close(Result.ABORTED);
        }
    }

    @Override
    public int depth() {
        this.manager.validateCurrentThread();
        return this.depth;
    }

    public void addClosingJournal(SnapshotJournal<?> journal) {
        this.manager.validateCurrentThread();
        this.validateOpen();
        this.journalsToClose.add(journal);
    }

    public void addClosingJournalToPrevDepth(SnapshotJournal<?> journal) {
        this.manager.getOpenTransaction(this.depth - 1).addClosingJournal(journal);
    }

    public void addCommittingJournal(SnapshotJournal<?> journal) {
        this.manager.validateCurrentThread();
        if (this.manager.currentDepth == -1) {
            throw new IllegalStateException("There is no open transaction on this thread.");
        }
        this.manager.journalsToCommitWithRoot.add(journal);
    }

    public String toString() {
        return "Transaction[depth=%d, lifecycle=%s, thread=%s]".formatted(this.depth, this.lifecycle.name(), this.manager.thread.getName());
    }

    Transaction(TransactionManager manager, int depth, Class<?> callerClass) {
        this.manager = manager;
        this.depth = depth;
        this.callerClass = callerClass;
    }

    void validateOpen() {
        if (!this.lifecycle.isOpen()) {
            throw new IllegalStateException("Transaction operation cannot be applied to a closed or closing transaction.");
        }
    }

    Lifecycle lifecycle() {
        this.manager.validateCurrentThread();
        return this.lifecycle;
    }

    String getDebugName() {
        return this.callerClass.toString();
    }

    private void close(Result result) {
        this.manager.validateCurrentTransaction(this);
        this.validateOpen();
        this.lifecycle = Lifecycle.CLOSING;
        Throwable closeException = null;
        for (SnapshotJournal<?> journal : this.journalsToClose) {
            try {
                journal.close(this, result.wasAborted());
            }
            catch (Exception exception) {
                if (closeException == null) {
                    closeException = new RuntimeException("Encountered an exception while invoking a transaction close callback.", exception);
                    continue;
                }
                closeException.addSuppressed(exception);
            }
        }
        this.journalsToClose.clear();
        if (this.manager.currentDepth == 0) {
            this.lifecycle = Lifecycle.ROOT_CLOSING;
            for (SnapshotJournal<?> journal : this.manager.journalsToCommitWithRoot) {
                try {
                    journal.commit();
                }
                catch (Exception exception) {
                    if (closeException == null) {
                        closeException = new RuntimeException("Encountered an exception while invoking a transaction root close callback.", exception);
                        continue;
                    }
                    closeException.addSuppressed(exception);
                }
            }
            this.manager.journalsToCommitWithRoot.clear();
        }
        --this.manager.currentDepth;
        this.lifecycle = Lifecycle.NONE;
        if (closeException != null) {
            throw closeException;
        }
    }

    public static enum Lifecycle {
        NONE,
        OPEN,
        CLOSING,
        ROOT_CLOSING;


        boolean isActive() {
            return this != NONE;
        }

        public boolean isOpen() {
            return this == OPEN;
        }
    }

    private static enum Result {
        ABORTED,
        COMMITTED;


        public boolean wasAborted() {
            return this == ABORTED;
        }
    }
}

