/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.transaction;

import java.util.ArrayList;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public abstract class SnapshotJournal<T> {
    private static final Object NO_SNAPSHOT = new Object();
    private final ArrayList<T> snapshots = new ArrayList();
    @Nullable
    private T originalState = null;

    protected abstract T createSnapshot();

    protected abstract void revertToSnapshot(T var1);

    protected void releaseSnapshot(T snapshot) {
    }

    protected void onRootCommit(T originalState) {
    }

    public void updateSnapshots(TransactionContext transaction) {
        int currentDepth = transaction.depth();
        this.snapshots.ensureCapacity(currentDepth);
        for (int i = this.snapshots.size(); i <= currentDepth; ++i) {
            this.snapshots.add(NO_SNAPSHOT);
        }
        if (this.snapshots.get(currentDepth) == NO_SNAPSHOT) {
            this.snapshots.set(currentDepth, this.createSnapshot());
            ((Transaction)transaction).addClosingJournal(this);
        }
    }

    void close(Transaction transaction, boolean wasAborted) {
        int currentDepth = transaction.depth();
        T snapshot = this.snapshots.remove(currentDepth);
        if (wasAborted) {
            this.revertToSnapshot(snapshot);
            this.releaseSnapshot(snapshot);
        } else if (currentDepth <= 0) {
            this.originalState = snapshot;
            transaction.addCommittingJournal(this);
        } else if (this.snapshots.get(currentDepth - 1) == NO_SNAPSHOT) {
            this.snapshots.set(currentDepth - 1, snapshot);
            transaction.addClosingJournalToPrevDepth(this);
        } else {
            this.releaseSnapshot(snapshot);
        }
    }

    final void commit() {
        this.onRootCommit(this.originalState);
        this.releaseSnapshot(this.originalState);
        this.originalState = null;
    }
}

