/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class ItemStackResourceHandler
extends SnapshotJournal<ItemStack>
implements ResourceHandler<ItemResource> {
    protected abstract ItemStack getStack();

    protected abstract void setStack(ItemStack var1);

    protected boolean isValid(ItemResource resource) {
        return true;
    }

    protected int getCapacity(ItemResource resource) {
        return resource.isEmpty() ? 99 : Math.min(resource.getMaxStackSize(), 99);
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        int insertedAmount;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        ItemStack currentStack = this.getStack();
        if ((currentStack.isEmpty() || resource.matches(currentStack)) && this.isValid(resource) && (insertedAmount = Math.min(amount, this.getCapacity(resource) - currentStack.getCount())) > 0) {
            this.updateSnapshots(transaction);
            currentStack = this.getStack();
            if (currentStack.isEmpty()) {
                currentStack = resource.toStack(insertedAmount);
            } else {
                currentStack.grow(insertedAmount);
            }
            this.setStack(currentStack);
            return insertedAmount;
        }
        return 0;
    }

    @Override
    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        int extracted;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        ItemStack currentStack = this.getStack();
        if (resource.matches(currentStack) && (extracted = Math.min(currentStack.getCount(), amount)) > 0) {
            this.updateSnapshots(transaction);
            currentStack = this.getStack();
            currentStack.shrink(extracted);
            this.setStack(currentStack);
            return extracted;
        }
        return 0;
    }

    @Override
    public ItemResource getResource(int index) {
        Objects.checkIndex(index, this.size());
        return ItemResource.of(this.getStack());
    }

    @Override
    public long getAmountAsLong(int index) {
        Objects.checkIndex(index, this.size());
        return this.getStack().getCount();
    }

    @Override
    public long getCapacityAsLong(int index, ItemResource resource) {
        Objects.checkIndex(index, this.size());
        return resource.isEmpty() || this.isValid(resource) ? (long)this.getCapacity(resource) : 0L;
    }

    @Override
    public boolean isValid(int index, ItemResource resource) {
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmpty(resource);
        return this.isValid(resource);
    }

    @Override
    protected ItemStack createSnapshot() {
        ItemStack original = this.getStack();
        this.setStack(original.copy());
        return original;
    }

    @Override
    protected void revertToSnapshot(ItemStack snapshot) {
        this.setStack(snapshot);
    }

    public String toString() {
        return this.getClass().getName() + "[" + String.valueOf(this.getStack()) + "]";
    }
}

