/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.access;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

class StackItemAccess
implements ItemAccess {
    private final Item item;
    private final ResourceHandler<ItemResource> wrapper;

    public StackItemAccess(ItemStack stack) {
        this.item = stack.getItem();
        this.wrapper = VanillaContainerWrapper.of((Container)new SimpleContainer(this, new ItemStack[]{stack}){

            public void setItem(int slot, ItemStack stack, boolean performSideEffects) {
                this.getItems().set(slot, (Object)stack);
            }
        });
    }

    @Override
    public ItemResource getResource() {
        return this.wrapper.getResource(0);
    }

    @Override
    public int getAmount() {
        return this.wrapper.getAmountAsInt(0);
    }

    @Override
    public int insert(ItemResource resource, int amount, TransactionContext transaction) {
        if (!resource.is(this.item)) {
            return 0;
        }
        return this.wrapper.insert(resource, amount, transaction);
    }

    @Override
    public int extract(ItemResource resource, int amount, TransactionContext transaction) {
        return this.wrapper.extract(resource, amount, transaction);
    }
}

