/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.filters;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.PermissionCheck;
import org.jetbrains.annotations.Nullable;

class CommandTreeCleaner {
    private static final Predicate<SharedSuggestionProvider> RESTRICTED = o -> true;
    public static final ClientboundCommandsPacket.NodeBuilder<SharedSuggestionProvider> COMMAND_NODE_BUILDER = new ClientboundCommandsPacket.NodeBuilder<SharedSuggestionProvider>(){

        public ArgumentBuilder<SharedSuggestionProvider, ?> createLiteral(String literal) {
            return LiteralArgumentBuilder.literal((String)literal);
        }

        public ArgumentBuilder<SharedSuggestionProvider, ?> createArgument(String name, ArgumentType<?> type, @Nullable ResourceLocation suggests) {
            RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument((String)name, type);
            if (suggests != null) {
                builder.suggests(SuggestionProviders.getProvider((ResourceLocation)suggests));
            }
            return builder;
        }

        public ArgumentBuilder<SharedSuggestionProvider, ?> configure(ArgumentBuilder<SharedSuggestionProvider, ?> builder, boolean executes, boolean restricted) {
            if (executes) {
                builder.executes(ctx -> 0);
            }
            if (restricted) {
                builder.requires(RESTRICTED);
            }
            return builder;
        }
    };
    public static final ClientboundCommandsPacket.NodeInspector<SharedSuggestionProvider> COMMAND_NODE_INSPECTOR = new ClientboundCommandsPacket.NodeInspector<SharedSuggestionProvider>(){

        @Nullable
        public ResourceLocation suggestionId(ArgumentCommandNode<SharedSuggestionProvider, ?> node) {
            SuggestionProvider suggestions = node.getCustomSuggestions();
            return suggestions != null ? SuggestionProviders.getName((SuggestionProvider)suggestions) : null;
        }

        public boolean isExecutable(CommandNode<SharedSuggestionProvider> node) {
            return node.getCommand() != null;
        }

        public boolean isRestricted(CommandNode<SharedSuggestionProvider> node) {
            PermissionCheck permissioncheck;
            Predicate predicate = node.getRequirement();
            return predicate instanceof PermissionCheck && (permissioncheck = (PermissionCheck)predicate).requiredLevel() > 0;
        }
    };

    CommandTreeCleaner() {
    }

    public static <S> RootCommandNode<S> cleanArgumentTypes(RootCommandNode<S> root, Predicate<ArgumentType<?>> argumentTypeFilter) {
        Predicate<CommandNode<?>> nodeFilter = node -> !(node instanceof ArgumentCommandNode) || argumentTypeFilter.test(((ArgumentCommandNode)node).getType());
        return (RootCommandNode)CommandTreeCleaner.processCommandNode(root, nodeFilter, new HashMap<CommandNode<S>, CommandNode<S>>());
    }

    private static <S> CommandNode<S> processCommandNode(CommandNode<S> node, Predicate<CommandNode<?>> nodeFilter, Map<CommandNode<S>, CommandNode<S>> newNodes) {
        CommandNode<S> existingNode = newNodes.get(node);
        if (existingNode == null) {
            CommandNode<S> newNode = CommandTreeCleaner.cloneNode(node, nodeFilter, newNodes);
            newNodes.put(node, newNode);
            node.getChildren().stream().filter(nodeFilter).map(child -> CommandTreeCleaner.processCommandNode(child, nodeFilter, newNodes)).forEach(arg_0 -> newNode.addChild(arg_0));
            return newNode;
        }
        return existingNode;
    }

    private static <S> CommandNode<S> cloneNode(CommandNode<S> node, Predicate<CommandNode<?>> nodeFilter, Map<CommandNode<S>, CommandNode<S>> newNodes) {
        if (node instanceof RootCommandNode) {
            return new RootCommandNode();
        }
        ArgumentBuilder builder = node.createBuilder();
        if (node.getRedirect() != null) {
            if (nodeFilter.test(node.getRedirect())) {
                builder.forward(CommandTreeCleaner.processCommandNode(node.getRedirect(), nodeFilter, newNodes), node.getRedirectModifier(), node.isFork());
            } else {
                builder.redirect(null);
            }
        }
        return builder.build();
    }
}

