/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.Nullable;

public class ClientCommandSourceStack
extends CommandSourceStack {
    public ClientCommandSourceStack(CommandSource source, Vec3 position, Vec2 rotation, int permission, String plainTextName, Component displayName, Entity executing) {
        super(source, position, rotation, null, permission, plainTextName, displayName, null, executing);
    }

    private ClientPacketListener connection() {
        return Minecraft.getInstance().getConnection();
    }

    public void sendSuccess(Supplier<Component> message, boolean sendToAdmins) {
        super.sendSuccess(message, false);
    }

    public Collection<String> getAllTeams() {
        return this.getScoreboard().getTeamNames();
    }

    public Collection<String> getOnlinePlayerNames() {
        return this.connection().getOnlinePlayers().stream().map(player -> player.getProfile().name()).collect(Collectors.toList());
    }

    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends Registry<?>> registry, SharedSuggestionProvider.ElementSuggestionType suggestionType, SuggestionsBuilder suggestionsBuilder, CommandContext<?> context) {
        if (registry == Registries.RECIPE) {
            return Suggestions.empty();
        }
        if (registry == Registries.ADVANCEMENT) {
            return SharedSuggestionProvider.suggestResource(this.connection().getAdvancements().getTree().nodes().stream().map(node -> node.holder().id()), (SuggestionsBuilder)suggestionsBuilder);
        }
        return super.suggestRegistryElements(registry, suggestionType, suggestionsBuilder, context);
    }

    public Set<ResourceKey<Level>> levels() {
        return this.connection().levels();
    }

    public RegistryAccess registryAccess() {
        return this.connection().registryAccess();
    }

    public FeatureFlagSet enabledFeatures() {
        return this.connection().enabledFeatures();
    }

    public Scoreboard getScoreboard() {
        return this.connection().scoreboard();
    }

    @Nullable
    public AdvancementHolder getAdvancement(ResourceLocation id) {
        return this.connection().getAdvancements().get(id);
    }

    public Level getUnsidedLevel() {
        return this.connection().getLevel();
    }

    public MinecraftServer getServer() {
        throw new UnsupportedOperationException("Attempted to get server in client command");
    }

    public ServerLevel getLevel() {
        throw new UnsupportedOperationException("Attempted to get server level in client command");
    }
}

