/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.ao;

import net.minecraft.core.Direction;

enum AoFace {
    DOWN,
    UP,
    NORTH,
    SOUTH,
    WEST,
    EAST;


    public static AoFace fromDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    float computeDepth(float x, float y, float z) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> y;
            case 1 -> 1.0f - y;
            case 2 -> z;
            case 3 -> 1.0f - z;
            case 4 -> x;
            case 5 -> 1.0f - x;
        };
    }

    void computeCornerWeights(float[] out, float x, float y, float z) {
        x = Math.clamp(x, 0.0f, 1.0f);
        y = Math.clamp(y, 0.0f, 1.0f);
        z = Math.clamp(z, 0.0f, 1.0f);
        switch (this.ordinal()) {
            case 0: {
                out[0] = (1.0f - x) * z;
                out[1] = (1.0f - x) * (1.0f - z);
                out[2] = x * (1.0f - z);
                out[3] = x * z;
                break;
            }
            case 1: {
                out[0] = x * z;
                out[1] = x * (1.0f - z);
                out[2] = (1.0f - x) * (1.0f - z);
                out[3] = (1.0f - x) * z;
                break;
            }
            case 2: {
                out[0] = y * (1.0f - x);
                out[1] = y * x;
                out[2] = (1.0f - y) * x;
                out[3] = (1.0f - y) * (1.0f - x);
                break;
            }
            case 3: {
                out[0] = y * (1.0f - x);
                out[1] = (1.0f - y) * (1.0f - x);
                out[2] = (1.0f - y) * x;
                out[3] = y * x;
                break;
            }
            case 4: {
                out[0] = y * z;
                out[1] = y * (1.0f - z);
                out[2] = (1.0f - y) * (1.0f - z);
                out[3] = (1.0f - y) * z;
                break;
            }
            case 5: {
                out[0] = (1.0f - y) * z;
                out[1] = (1.0f - y) * (1.0f - z);
                out[2] = y * (1.0f - z);
                out[3] = y * z;
            }
        }
    }
}

