/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.conditions.ICondition;

public class DatapackBuiltinEntriesProvider
extends RegistriesDatapackGenerator {
    private final CompletableFuture<HolderLookup.Provider> fullRegistries;

    public DatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<RegistrySetBuilder.PatchedRegistries> registries, Set<String> modIds) {
        this(output, registries, (BiConsumer<ResourceKey<?>, ICondition> b) -> {}, modIds);
    }

    public DatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<RegistrySetBuilder.PatchedRegistries> registries, Consumer<BiConsumer<ResourceKey<?>, ICondition>> conditionsBuilder, Set<String> modIds) {
        this(output, registries, DatapackBuiltinEntriesProvider.buildConditionsMap(conditionsBuilder), modIds);
    }

    public DatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<RegistrySetBuilder.PatchedRegistries> registries, Map<ResourceKey<?>, List<ICondition>> conditions, Set<String> modIds) {
        super(output, (CompletableFuture)registries.thenApply(RegistrySetBuilder.PatchedRegistries::patches), modIds, conditions);
        this.fullRegistries = registries.thenApply(RegistrySetBuilder.PatchedRegistries::full);
    }

    public DatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, RegistrySetBuilder datapackEntriesBuilder, Set<String> modIds) {
        this(output, RegistryPatchGenerator.createLookup(registries, (RegistrySetBuilder)datapackEntriesBuilder), modIds);
    }

    public DatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, RegistrySetBuilder datapackEntriesBuilder, Map<ResourceKey<?>, List<ICondition>> conditions, Set<String> modIds) {
        this(output, (CompletableFuture<RegistrySetBuilder.PatchedRegistries>)RegistryPatchGenerator.createLookup(registries, (RegistrySetBuilder)datapackEntriesBuilder), conditions, modIds);
    }

    public DatapackBuiltinEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, RegistrySetBuilder datapackEntriesBuilder, Consumer<BiConsumer<ResourceKey<?>, ICondition>> conditionsBuilder, Set<String> modIds) {
        this(output, (CompletableFuture<RegistrySetBuilder.PatchedRegistries>)RegistryPatchGenerator.createLookup(registries, (RegistrySetBuilder)datapackEntriesBuilder), conditionsBuilder, modIds);
    }

    public CompletableFuture<HolderLookup.Provider> getRegistryProvider() {
        return this.fullRegistries;
    }

    private static Map<ResourceKey<?>, List<ICondition>> buildConditionsMap(Consumer<BiConsumer<ResourceKey<?>, ICondition>> conditionBuilder) {
        IdentityHashMap conditions = new IdentityHashMap();
        conditionBuilder.accept((key, condition) -> conditions.computeIfAbsent((ResourceKey<?>)key, k -> new ArrayList()).add(condition));
        return conditions;
    }
}

