/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.standalone;

import java.util.function.BiFunction;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;

public final class SimpleUnbakedStandaloneModel<T>
implements UnbakedStandaloneModel<T> {
    private final ResourceLocation modelId;
    private final BiFunction<ResolvedModel, ModelBaker, T> bake;

    public SimpleUnbakedStandaloneModel(ResourceLocation modelId, BiFunction<ResolvedModel, ModelBaker, T> bake) {
        this.modelId = modelId;
        this.bake = bake;
    }

    @Override
    public T bake(ModelBaker baker) {
        return this.bake.apply(baker.getModel(this.modelId), baker);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        resolver.markDependency(this.modelId);
    }

    public static SimpleUnbakedStandaloneModel<SimpleModelWrapper> simpleModelWrapper(ResourceLocation modelId) {
        return new SimpleUnbakedStandaloneModel<SimpleModelWrapper>(modelId, (model, baker) -> SimpleModelWrapper.bake((ModelBaker)baker, (ResolvedModel)model, (ModelState)BlockModelRotation.X0_Y0));
    }

    public static SimpleUnbakedStandaloneModel<SimpleModelWrapper> simpleModelWrapper(ResourceLocation modelId, ModelState modelState) {
        return new SimpleUnbakedStandaloneModel<SimpleModelWrapper>(modelId, (model, baker) -> SimpleModelWrapper.bake((ModelBaker)baker, (ResolvedModel)model, (ModelState)modelState));
    }

    public static SimpleUnbakedStandaloneModel<BlockStateModel> blockStateModel(ResourceLocation modelId) {
        return new SimpleUnbakedStandaloneModel<BlockStateModel>(modelId, (model, baker) -> new SingleVariant((BlockModelPart)SimpleModelWrapper.bake((ModelBaker)baker, (ResolvedModel)model, (ModelState)BlockModelRotation.X0_Y0)));
    }

    public static SimpleUnbakedStandaloneModel<BlockStateModel> blockStateModel(ResourceLocation modelId, ModelState modelState) {
        return new SimpleUnbakedStandaloneModel<BlockStateModel>(modelId, (model, baker) -> new SingleVariant((BlockModelPart)SimpleModelWrapper.bake((ModelBaker)baker, (ResolvedModel)model, (ModelState)modelState)));
    }

    public static SimpleUnbakedStandaloneModel<QuadCollection> quadCollection(ResourceLocation modelId) {
        return new SimpleUnbakedStandaloneModel<QuadCollection>(modelId, (model, baker) -> model.bakeTopGeometry(model.getTopTextureSlots(), baker, (ModelState)BlockModelRotation.X0_Y0));
    }

    public static SimpleUnbakedStandaloneModel<QuadCollection> quadCollection(ResourceLocation modelId, ModelState modelState) {
        return new SimpleUnbakedStandaloneModel<QuadCollection>(modelId, (model, baker) -> model.bakeTopGeometry(model.getTopTextureSlots(), baker, modelState));
    }
}

