/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.random.Weighted;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.gametest.GameTestHooks;
import net.neoforged.neoforge.mixins.MappedRegistryAccessor;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.server.LanguageHook;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class ServerLifecycleHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SERVERHOOKS = MarkerManager.getMarker((String)"SERVERHOOKS");
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");
    @Nullable
    private static volatile CountDownLatch exitLatch = null;
    @Nullable
    private static MinecraftServer currentServer;

    private static Path getServerConfigPath(MinecraftServer server) {
        Path explanation;
        Path serverConfig = server.getWorldPath(SERVERCONFIG);
        if (!Files.isDirectory(serverConfig, new LinkOption[0])) {
            try {
                Files.createDirectories(serverConfig, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!Files.exists(explanation = serverConfig.resolve("readme.txt"), new LinkOption[0])) {
            try {
                Files.writeString(explanation, (CharSequence)"Any server configs put in this folder will override the corresponding server config from <instance path>/config/<config path>.\nIf the config being transferred is in a subfolder of the base config folder make sure to include that folder here in the path to the file you are overwriting.\nFor example if you are overwriting a config with the path <instance path>/config/ExampleMod/config-server.toml, you would need to put it in serverconfig/ExampleMod/config-server.toml\n", StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return serverConfig;
    }

    public static void handleServerAboutToStart(MinecraftServer server) {
        currentServer = server;
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, FMLPaths.CONFIGDIR.get(), ServerLifecycleHooks.getServerConfigPath(server));
        ServerLifecycleHooks.runModifiers(server);
        NeoForge.EVENT_BUS.post((Event)new ServerAboutToStartEvent(server));
    }

    public static void handleServerStarting(MinecraftServer server) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            LanguageHook.loadModLanguages(server);
            if (!(server instanceof GameTestServer)) {
                GameTestHooks.registerGametests((RegistryAccess)server.registryAccess());
            }
        }
        PermissionAPI.initializePermissionAPI();
        NeoForge.EVENT_BUS.post((Event)new ServerStartingEvent(server));
    }

    public static void handleServerStarted(MinecraftServer server) {
        NeoForge.EVENT_BUS.post((Event)new ServerStartedEvent(server));
    }

    public static void handleServerStopping(MinecraftServer server) {
        NeoForge.EVENT_BUS.post((Event)new ServerStoppingEvent(server));
    }

    public static void expectServerStopped() {
        exitLatch = new CountDownLatch(1);
    }

    public static void handleServerStopped(MinecraftServer server) {
        NeoForge.EVENT_BUS.post((Event)new ServerStoppedEvent(server));
        currentServer = null;
        CountDownLatch latch = exitLatch;
        if (latch != null) {
            latch.countDown();
            exitLatch = null;
        }
        ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER);
    }

    @Nullable
    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static void handleExit(int retVal) {
        System.exit(retVal);
    }

    private static <T> void ensureProperSync(boolean modified, Holder.Reference<T> holder, Registry<T> registry) {
        if (modified) {
            Optional originalInfo = registry.registrationInfo(holder.key());
            originalInfo.ifPresent(info -> {
                RegistrationInfo newInfo = new RegistrationInfo(Optional.empty(), info.lifecycle());
                ((MappedRegistryAccessor)registry).neoforge$getRegistrationInfos().put(holder.key(), newInfo);
            });
        }
    }

    private static void runModifiers(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.registryAccess();
        List<BiomeModifier> biomeModifiers = registries.lookupOrThrow(NeoForgeRegistries.Keys.BIOME_MODIFIERS).listElements().map(Holder::value).toList();
        List<StructureModifier> structureModifiers = registries.lookupOrThrow(NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS).listElements().map(Holder::value).toList();
        HashSet entitiesWithoutPlacements = new HashSet();
        Registry biomeRegistry = registries.lookupOrThrow(Registries.BIOME);
        biomeRegistry.listElements().forEach(arg_0 -> ServerLifecycleHooks.lambda$runModifiers$3(biomeModifiers, (RegistryAccess)registries, biomeRegistry, entitiesWithoutPlacements, arg_0));
        registries.lookupOrThrow(Registries.LEVEL_STEM).forEach(levelStem -> levelStem.generator().refreshFeaturesPerStep());
        registries.lookupOrThrow(Registries.STRUCTURE).listElements().forEach(structureHolder -> ((Structure)structureHolder.value()).modifiableStructureInfo().applyStructureModifiers((Holder<Structure>)structureHolder, structureModifiers));
        if (!entitiesWithoutPlacements.isEmpty() && !FMLLoader.isProduction()) {
            LOGGER.error("The following entities have not registered to the RegisterSpawnPlacementsEvent, but a spawn entry was found. This will mean that the entity doesn't have restrictions on its spawn location, please register a spawn placement for the entity, you can register with NO_RESTRICTIONS if you don't want any restrictions." + entitiesWithoutPlacements.stream().map(EntityType::getKey).map(ResourceLocation::toString).collect(Collectors.joining("\n\t - ", "\n\t - ", "")));
        }
    }

    private static /* synthetic */ void lambda$runModifiers$3(List biomeModifiers, RegistryAccess registries, Registry biomeRegistry, Set entitiesWithoutPlacements, Holder.Reference biomeHolder) {
        Biome biome = (Biome)biomeHolder.value();
        ServerLifecycleHooks.ensureProperSync(biome.modifiableBiomeInfo().applyBiomeModifiers((Holder<Biome>)biomeHolder, biomeModifiers, registries), biomeHolder, biomeRegistry);
        MobSpawnSettings mobSettings = biome.getMobSettings();
        mobSettings.getSpawnerTypes().forEach(category -> mobSettings.getMobs(category).unwrap().forEach(data -> {
            if (SpawnPlacements.hasPlacement((EntityType)((MobSpawnSettings.SpawnerData)data.value()).type())) {
                return;
            }
            entitiesWithoutPlacements.add(((MobSpawnSettings.SpawnerData)data.value()).type());
        }));
        for (MobCategory mobCategory : mobSettings.getSpawnerTypes()) {
            for (Weighted spawnerData : mobSettings.getMobs(mobCategory).unwrap()) {
                boolean isVanillaBug;
                if (((MobSpawnSettings.SpawnerData)spawnerData.value()).type().getCategory() == mobCategory || (isVanillaBug = ((MobSpawnSettings.SpawnerData)spawnerData.value()).type() == EntityType.OCELOT && (biomeHolder.is(Biomes.JUNGLE) || biomeHolder.is(Biomes.BAMBOO_JUNGLE)))) continue;
                LOGGER.warn("Detected {} that was registered with {} mob category but was added under {} mob category for {} biome! Mobs should be added to biomes under the same mob category that the mob was registered as to prevent mob cap spawning issues.", (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)((MobSpawnSettings.SpawnerData)spawnerData.value()).type()), (Object)((MobSpawnSettings.SpawnerData)spawnerData.value()).type().getCategory(), (Object)mobCategory, (Object)biomeHolder.getKey().location());
            }
        }
    }
}

