/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.model.data;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.model.data.ModelData;
import org.jetbrains.annotations.UnmodifiableView;

@EventBusSubscriber(modid="neoforge", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ModelDataManager {
    private final Thread owningThread = Thread.currentThread();
    private final Level level;
    private final Long2ObjectMap<Set<BlockPos>> needModelDataRefresh = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<Long2ObjectMap<ModelData>> modelDataCache = new Long2ObjectOpenHashMap();
    public static final Long2ObjectFunction<ModelData> EMPTY_SNAPSHOT = pos -> ModelData.EMPTY;

    public ModelDataManager(Level level) {
        this.level = level;
    }

    public void requestRefresh(BlockEntity blockEntity) {
        if (this.isOtherThread()) {
            throw new UnsupportedOperationException("Cannot request ModelData refresh outside the owning thread: " + String.valueOf(this.owningThread));
        }
        Preconditions.checkNotNull((Object)blockEntity, (Object)"BlockEntity must not be null");
        Preconditions.checkState((blockEntity.getLevel() == this.level ? 1 : 0) != 0, (Object)"BlockEntity does not belong to the level owning this manager");
        ((Set)this.needModelDataRefresh.computeIfAbsent(SectionPos.asLong((BlockPos)blockEntity.getBlockPos()), $ -> new HashSet())).add(blockEntity.getBlockPos());
    }

    public @UnmodifiableView Long2ObjectMap<ModelData> getAt(SectionPos pos) {
        long sectionKey = pos.asLong();
        this.refreshAt(sectionKey);
        Long2ObjectMap map = (Long2ObjectMap)this.modelDataCache.get(sectionKey);
        if (map != null) {
            return Long2ObjectMaps.unmodifiable((Long2ObjectMap)map);
        }
        return Long2ObjectMaps.emptyMap();
    }

    public ModelData getAt(BlockPos pos) {
        Preconditions.checkArgument((boolean)this.level.isClientSide, (Object)"Cannot request model data for server level");
        long sectionPos = SectionPos.asLong((BlockPos)pos);
        this.refreshAt(sectionPos);
        return (ModelData)((Long2ObjectMap)this.modelDataCache.getOrDefault(sectionPos, (Object)Long2ObjectMaps.emptyMap())).getOrDefault(pos.asLong(), (Object)ModelData.EMPTY);
    }

    public Long2ObjectFunction<ModelData> snapshotSectionRegion(int sectionMinX, int sectionMinY, int sectionMinZ, int sectionMaxX, int sectionMaxY, int sectionMaxZ) {
        if (this.isOtherThread()) {
            throw new UnsupportedOperationException("Cannot snapshot active manager outside the owning thread: " + String.valueOf(this.owningThread));
        }
        Long2ObjectOpenHashMap cache = new Long2ObjectOpenHashMap();
        cache.defaultReturnValue((Object)ModelData.EMPTY);
        for (int x = sectionMinX; x <= sectionMaxX; ++x) {
            for (int y = sectionMinY; y <= sectionMaxY; ++y) {
                for (int z = sectionMinZ; z <= sectionMaxZ; ++z) {
                    long sectionPos = SectionPos.asLong((int)x, (int)y, (int)z);
                    this.refreshAt(sectionPos);
                    cache.putAll((Map)this.modelDataCache.getOrDefault(sectionPos, (Object)Long2ObjectMaps.emptyMap()));
                }
            }
        }
        return cache.isEmpty() ? EMPTY_SNAPSHOT : cache;
    }

    private void refreshAt(long section) {
        if (this.isOtherThread()) {
            return;
        }
        Set needUpdate = (Set)this.needModelDataRefresh.remove(section);
        if (needUpdate != null) {
            Long2ObjectMap data = (Long2ObjectMap)this.modelDataCache.computeIfAbsent(section, $ -> new Long2ObjectOpenHashMap());
            for (BlockPos pos : needUpdate) {
                BlockEntity toUpdate = this.level.getBlockEntity(pos);
                ModelData newData = ModelData.EMPTY;
                if (toUpdate != null && !toUpdate.isRemoved() && (newData = toUpdate.getModelData()) == null) {
                    throw new NullPointerException("Null ModelData provided by " + String.valueOf(BlockEntityType.getKey((BlockEntityType)toUpdate.getType())) + " @ " + String.valueOf(pos));
                }
                if (newData != ModelData.EMPTY) {
                    data.put(pos.asLong(), (Object)newData);
                    continue;
                }
                data.remove(pos.asLong());
            }
            if (data.isEmpty()) {
                this.modelDataCache.remove(section);
            }
        }
    }

    private boolean isOtherThread() {
        return Thread.currentThread() != this.owningThread;
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        Level level = ((LevelChunk)event.getChunk()).getLevel();
        if (level == null) {
            return;
        }
        ModelDataManager modelDataManager = level.getModelDataManager();
        if (modelDataManager != null) {
            ChunkPos chunk = ((LevelChunk)event.getChunk()).getPos();
            int maxSection = level.getMaxSectionY();
            for (int y = level.getMinSectionY(); y < maxSection; ++y) {
                long section = SectionPos.asLong((int)chunk.x, (int)y, (int)chunk.z);
                modelDataManager.needModelDataRefresh.remove(section);
                modelDataManager.modelDataCache.remove(section);
            }
        }
    }
}

