/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.IRenderableSection;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RenderLevelStageEvent
extends Event {
    private final Stage stage;
    private final Level level;
    private final LevelRenderer levelRenderer;
    private final PoseStack poseStack;
    private final Matrix4f modelViewMatrix;
    private final Matrix4f projectionMatrix;
    private final int renderTick;
    private final DeltaTracker partialTick;
    private final Camera camera;
    private final Frustum frustum;
    private final Iterable<? extends IRenderableSection> renderableSections;

    public RenderLevelStageEvent(Stage stage, Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, int renderTick, DeltaTracker partialTick, Camera camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
        this.stage = stage;
        this.level = level;
        this.levelRenderer = levelRenderer;
        this.poseStack = poseStack != null ? poseStack : new PoseStack();
        this.modelViewMatrix = modelViewMatrix;
        this.projectionMatrix = projectionMatrix;
        this.renderTick = renderTick;
        this.partialTick = partialTick;
        this.camera = camera;
        this.frustum = frustum;
        this.renderableSections = renderableSections;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Level getLevel() {
        return this.level;
    }

    public LevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public Matrix4f getModelViewMatrix() {
        return this.modelViewMatrix;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public int getRenderTick() {
        return this.renderTick;
    }

    public DeltaTracker getPartialTick() {
        return this.partialTick;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Frustum getFrustum() {
        return this.frustum;
    }

    public Iterable<? extends IRenderableSection> getRenderableSections() {
        return this.renderableSections;
    }

    public static class Stage {
        private static final Map<RenderType, Stage> RENDER_TYPE_STAGES = new HashMap<RenderType, Stage>();
        public static final Stage AFTER_SKY = Stage.register("after_sky", null);
        public static final Stage AFTER_SOLID_BLOCKS = Stage.register("after_solid_blocks", RenderType.solid());
        public static final Stage AFTER_CUTOUT_MIPPED_BLOCKS_BLOCKS = Stage.register("after_cutout_mipped_blocks", RenderType.cutoutMipped());
        public static final Stage AFTER_CUTOUT_BLOCKS = Stage.register("after_cutout_blocks", RenderType.cutout());
        public static final Stage AFTER_ENTITIES = Stage.register("after_entities", null);
        public static final Stage AFTER_BLOCK_ENTITIES = Stage.register("after_block_entities", null);
        public static final Stage AFTER_TRANSLUCENT_BLOCKS = Stage.register("after_translucent_blocks", RenderType.translucent());
        public static final Stage AFTER_TRIPWIRE_BLOCKS = Stage.register("after_tripwire_blocks", RenderType.tripwire());
        public static final Stage AFTER_PARTICLES = Stage.register("after_particles", null);
        public static final Stage AFTER_WEATHER = Stage.register("after_weather", null);
        public static final Stage AFTER_LEVEL = Stage.register("after_level", null);
        private final String name;

        private Stage(String name) {
            this.name = name;
        }

        private static Stage register(ResourceLocation name, @Nullable RenderType renderType) throws IllegalArgumentException {
            Stage stage = new Stage(name.toString());
            if (renderType != null && RENDER_TYPE_STAGES.putIfAbsent(renderType, stage) != null) {
                throw new IllegalArgumentException("Attempted to replace an existing RenderLevelStageEvent.Stage for a RenderType: Stage = " + String.valueOf(stage) + ", RenderType = " + String.valueOf(renderType));
            }
            return stage;
        }

        private static Stage register(String name, @Nullable RenderType renderType) throws IllegalArgumentException {
            return Stage.register(ResourceLocation.parse((String)name), renderType);
        }

        public String toString() {
            return this.name;
        }

        @Nullable
        public static Stage fromRenderType(RenderType renderType) {
            return RENDER_TYPE_STAGES.get(renderType);
        }
    }

    public static class RegisterStageEvent
    extends Event
    implements IModBusEvent {
        public Stage register(ResourceLocation name, @Nullable RenderType renderType) throws IllegalArgumentException {
            return Stage.register(name, renderType);
        }
    }
}

