/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.resource.RenderTargetDescriptor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicInfo;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.locale.Language;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.earlydisplay.DisplayWindow;
import net.neoforged.fml.loading.EarlyLoadingScreenController;
import net.neoforged.neoforge.client.ColorResolverManager;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;
import net.neoforged.neoforge.client.DimensionTransitionScreenManager;
import net.neoforged.neoforge.client.EntitySpectatorShaderManager;
import net.neoforged.neoforge.client.ItemDecoratorHandler;
import net.neoforged.neoforge.client.NamedRenderTypeManager;
import net.neoforged.neoforge.client.PresetEditorManager;
import net.neoforged.neoforge.client.RecipeBookManager;
import net.neoforged.neoforge.client.config.NeoForgeClientConfig;
import net.neoforged.neoforge.client.entity.animation.json.AnimationTypeManager;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import net.neoforged.neoforge.client.event.CalculateDetachedCameraDistanceEvent;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.ClientChatEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientPauseChangeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerChangeGameTypeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientResourceLoadFinishedEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.ConfigureMainRenderTargetEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.FrameGraphSetupEvent;
import net.neoforged.neoforge.client.event.GatherEffectScreenTooltipsEvent;
import net.neoforged.neoforge.client.event.InitializeClientRegistriesEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.PlayerHeartTypeEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMaterialAtlasesEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderArmEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ScreenshotEvent;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.event.ToastAddEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.client.extensions.common.ClientExtensionsManager;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.client.gui.ClientTooltipComponentManager;
import net.neoforged.neoforge.client.gui.map.MapDecorationRendererManager;
import net.neoforged.neoforge.client.internal.ForgeSnapshotsModClient;
import net.neoforged.neoforge.client.loading.NeoForgeLoadingOverlay;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.block.BlockStateModelHooks;
import net.neoforged.neoforge.client.pipeline.PipelineModifiers;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.common.DataMapHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.SortedReloadListenerEvent;
import net.neoforged.neoforge.internal.BrandingControl;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ClientHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CLIENTHOOKS = MarkerManager.getMarker((String)"CLIENTHOOKS");
    private static final Stack<Screen> guiLayers = new Stack();
    private static int slotMainHand = 0;
    private static final Map<ModelLayerLocation, Supplier<LayerDefinition>> layerDefinitions = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
    private static final Map<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>> skullModelsByType = new HashMap<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>>();
    private static final ResourceLocation ICON_SHEET = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"textures/gui/icons.png");
    private static boolean initializedClientHooks = false;
    private static boolean initializedClientRegistries = false;
    private static final ExtensionInfo RECIPE_BOOK_TYPE_EXTENSION_INFO = RecipeBookType.getExtensionInfo();
    private static final RecipeBookType[] RECIPE_BOOK_TYPES = RecipeBookType.values();
    private static RecipeBookType @Nullable [] cachedFilteredTypes = null;
    private static final RandomSource OUTLINE_PASS_RANDOM = RandomSource.create();
    private static final List<BlockModelPart> OUTLINE_PART_SCRATCH_LIST = new ObjectArrayList();

    public static void resizeGuiLayers(Minecraft minecraft, int width, int height) {
        guiLayers.forEach(screen -> screen.resize(minecraft, width, height));
    }

    public static void clearGuiLayers(Minecraft minecraft) {
        while (!guiLayers.isEmpty()) {
            ClientHooks.popGuiLayerInternal(minecraft);
        }
    }

    private static void popGuiLayerInternal(Minecraft minecraft) {
        if (minecraft.screen != null) {
            minecraft.screen.removed();
        }
        minecraft.screen = guiLayers.pop();
    }

    public static void pushGuiLayer(Minecraft minecraft, Screen screen) {
        if (minecraft.screen != null) {
            guiLayers.push(minecraft.screen);
        }
        minecraft.screen = Objects.requireNonNull(screen);
        screen.init(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
        minecraft.getNarrator().sayNow(screen.getNarrationMessage());
    }

    public static void popGuiLayer(Minecraft minecraft) {
        if (guiLayers.isEmpty()) {
            minecraft.setScreen(null);
            return;
        }
        ClientHooks.popGuiLayerInternal(minecraft);
        if (minecraft.screen != null) {
            minecraft.getNarrator().sayNow(minecraft.screen.getNarrationMessage());
        }
    }

    public static float getGuiFarPlane() {
        float depth = 10000.0f * (float)(1 + guiLayers.size());
        if (Minecraft.getInstance().level != null) {
            depth = Math.max(depth, 200.0f * (float)Minecraft.getInstance().gui.getLayerCount());
        }
        return 11000.0f + depth;
    }

    public static Gui.HeartType firePlayerHeartTypeEvent(Player player, Gui.HeartType heartType) {
        return ((PlayerHeartTypeEvent)NeoForge.EVENT_BUS.post((Event)new PlayerHeartTypeEvent(player, heartType))).getType();
    }

    public static ResourceLocation getArmorTexture(ItemStack armor, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
        ResourceLocation result = IClientItemExtensions.of(armor).getArmorTexture(armor, type, layer, _default);
        return result != null ? result : _default;
    }

    public static boolean onClientPauseChangePre(boolean pause) {
        ClientPauseChangeEvent.Pre event = (ClientPauseChangeEvent.Pre)NeoForge.EVENT_BUS.post((Event)new ClientPauseChangeEvent.Pre(pause));
        return event.isCanceled();
    }

    public static void onClientPauseChangePost(boolean pause) {
        NeoForge.EVENT_BUS.post((Event)new ClientPauseChangeEvent.Post(pause));
    }

    public static boolean onDrawHighlight(LevelRenderer context, Camera camera, BlockHitResult target, DeltaTracker deltaTracker, PoseStack poseStack, MultiBufferSource bufferSource, boolean forTranslucentBlocks) {
        return ((RenderHighlightEvent.Block)NeoForge.EVENT_BUS.post((Event)new RenderHighlightEvent.Block(context, camera, target, deltaTracker, poseStack, bufferSource, forTranslucentBlocks))).isCanceled();
    }

    public static void dispatchRenderStage(RenderLevelStageEvent.Stage stage, Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, int renderTick, Camera camera, Frustum frustum) {
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = Profiler.get();
        profiler.push(stage.toString());
        NeoForge.EVENT_BUS.post((Event)new RenderLevelStageEvent(stage, level, levelRenderer, poseStack, modelViewMatrix, projectionMatrix, renderTick, mc.getDeltaTracker(), camera, frustum, levelRenderer.getRenderableSections()));
        profiler.pop();
    }

    public static void dispatchRenderStage(RenderType renderType, Level level, LevelRenderer levelRenderer, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, int renderTick, Camera camera, Frustum frustum) {
        RenderLevelStageEvent.Stage stage = RenderLevelStageEvent.Stage.fromRenderType(renderType);
        if (stage != null) {
            ClientHooks.dispatchRenderStage(stage, level, levelRenderer, null, modelViewMatrix, projectionMatrix, renderTick, camera, frustum);
        }
    }

    public static boolean renderSpecificFirstPersonHand(InteractionHand hand, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick, float interpPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return ((RenderHandEvent)NeoForge.EVENT_BUS.post((Event)new RenderHandEvent(hand, poseStack, bufferSource, packedLight, partialTick, interpPitch, swingProgress, equipProgress, stack))).isCanceled();
    }

    public static boolean renderSpecificFirstPersonArm(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, AbstractClientPlayer player, HumanoidArm arm) {
        return ((RenderArmEvent)NeoForge.EVENT_BUS.post((Event)new RenderArmEvent(poseStack, multiBufferSource, packedLight, player, arm))).isCanceled();
    }

    public static void onTextureAtlasStitched(TextureAtlas atlas) {
        ModLoader.postEvent((Event)new TextureAtlasStitchedEvent(atlas));
    }

    public static void onBlockColorsInit(BlockColors blockColors) {
        ModLoader.postEvent((Event)new RegisterColorHandlersEvent.Block(blockColors));
    }

    public static <T extends HumanoidRenderState> void copyModelProperties(HumanoidModel<T> original, HumanoidModel<?> replacement) {
        original.copyPropertiesTo(replacement);
        replacement.head.visible = original.head.visible;
        replacement.hat.visible = original.hat.visible;
        replacement.body.visible = original.body.visible;
        replacement.rightArm.visible = original.rightArm.visible;
        replacement.leftArm.visible = original.leftArm.visible;
        replacement.rightLeg.visible = original.rightLeg.visible;
        replacement.leftLeg.visible = original.leftLeg.visible;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ":" + base + name;
        }
        return base + name;
    }

    public static float getFieldOfViewModifier(Player entity, float fovModifier, float fovScale) {
        ComputeFovModifierEvent fovModifierEvent = new ComputeFovModifierEvent(entity, fovModifier, fovScale);
        NeoForge.EVENT_BUS.post((Event)fovModifierEvent);
        return fovModifierEvent.getNewFovModifier();
    }

    public static float getFieldOfView(GameRenderer renderer, Camera camera, float partialTick, float fov, boolean usedConfiguredFov) {
        ViewportEvent.ComputeFov event = new ViewportEvent.ComputeFov(renderer, camera, partialTick, fov, usedConfiguredFov);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getFOV();
    }

    public static CalculatePlayerTurnEvent getTurnPlayerValues(double mouseSensitivity, boolean cinematicCameraEnabled) {
        CalculatePlayerTurnEvent event = new CalculatePlayerTurnEvent(mouseSensitivity, cinematicCameraEnabled);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static float getDetachedCameraDistance(Camera camera, boolean flipped, float entityScale, float distance) {
        CalculateDetachedCameraDistanceEvent event = new CalculateDetachedCameraDistanceEvent(camera, flipped, entityScale, distance);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getDistance();
    }

    public static void renderMainMenu(TitleScreen gui, GuiGraphics guiGraphics, Font font, int width, int height, int alpha) {
        ForgeSnapshotsModClient.renderMainMenuWarning(NeoForgeVersion.getVersion(), guiGraphics, font, width, height, alpha);
        BrandingControl.setForgeStatusLine(switch (NeoForgeVersion.getStatus()) {
            case VersionChecker.Status.OUTDATED, VersionChecker.Status.BETA_OUTDATED -> I18n.get((String)"neoforge.update.newversion", (Object[])new Object[]{NeoForgeVersion.getTarget()});
            default -> null;
        });
    }

    @Nullable
    public static SoundInstance playSound(SoundEngine manager, SoundInstance sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        NeoForge.EVENT_BUS.post((Event)e);
        return e.getSound();
    }

    @Nullable
    public static MusicInfo selectMusic(MusicInfo situational, @Nullable SoundInstance playing) {
        SelectMusicEvent e = new SelectMusicEvent(situational, playing);
        NeoForge.EVENT_BUS.post((Event)e);
        return e.getMusic();
    }

    public static void drawScreen(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushPose();
        guiLayers.forEach(layer -> {
            ClientHooks.drawScreenInternal(layer, guiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTick);
            guiGraphics.pose().translate(0.0f, 0.0f, 10000.0f);
        });
        ClientHooks.drawScreenInternal(screen, guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().popPose();
    }

    private static void drawScreenInternal(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!((ScreenEvent.Render.Pre)NeoForge.EVENT_BUS.post((Event)new ScreenEvent.Render.Pre(screen, guiGraphics, mouseX, mouseY, partialTick))).isCanceled()) {
            screen.renderWithTooltip(guiGraphics, mouseX, mouseY, partialTick);
        }
        NeoForge.EVENT_BUS.post((Event)new ScreenEvent.Render.Post(screen, guiGraphics, mouseX, mouseY, partialTick));
    }

    public static Vector4f getFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, float fogRed, float fogGreen, float fogBlue) {
        FluidState state = level.getFluidState(camera.getBlockPosition());
        Vector4f fluidFogColor = new Vector4f(fogRed, fogGreen, fogBlue, 1.0f);
        if (camera.getPosition().y < (double)((float)camera.getBlockPosition().getY() + state.getHeight((BlockGetter)level, camera.getBlockPosition()))) {
            fluidFogColor = IClientFluidTypeExtensions.of(state).modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, fluidFogColor);
        }
        ViewportEvent.ComputeFogColor event = new ViewportEvent.ComputeFogColor(camera, partialTick, fluidFogColor.x(), fluidFogColor.y(), fluidFogColor.z());
        NeoForge.EVENT_BUS.post((Event)event);
        fluidFogColor.set(event.getRed(), event.getGreen(), event.getBlue());
        return fluidFogColor;
    }

    public static FogParameters onFogRender(FogRenderer.FogMode mode, FogType type, Camera camera, float partialTick, float renderDistance, FogParameters fogParameters) {
        ViewportEvent.RenderFog event;
        FluidState state = camera.getEntity().level().getFluidState(camera.getBlockPosition());
        if (camera.getPosition().y < (double)((float)camera.getBlockPosition().getY() + state.getHeight((BlockGetter)camera.getEntity().level(), camera.getBlockPosition()))) {
            fogParameters = IClientFluidTypeExtensions.of(state).modifyFogRender(camera, mode, renderDistance, partialTick, fogParameters);
        }
        if (((ViewportEvent.RenderFog)NeoForge.EVENT_BUS.post((Event)(event = new ViewportEvent.RenderFog(mode, type, camera, partialTick, fogParameters)))).isCanceled()) {
            return new FogParameters(event.getNearPlaneDistance(), event.getFarPlaneDistance(), event.getFogShape(), fogParameters.red(), fogParameters.green(), fogParameters.blue(), fogParameters.alpha());
        }
        return fogParameters;
    }

    public static void onModifyBakingResult(ModelBakery.BakingResult bakingResult, Map<ResourceLocation, AtlasSet.StitchResult> stitchResults, ModelBakery modelBakery) {
        Function<Material, TextureAtlasSprite> textureGetter = material -> {
            AtlasSet.StitchResult stitchResult = (AtlasSet.StitchResult)stitchResults.get(material.atlasLocation());
            TextureAtlasSprite sprite = stitchResult.getSprite(material.texture());
            if (sprite != null) {
                return sprite;
            }
            LOGGER.warn("Failed to retrieve texture '{}' from atlas '{}'", (Object)material.texture(), (Object)material.atlasLocation(), (Object)new Throwable());
            return stitchResult.missing();
        };
        ModLoader.postEvent((Event)new ModelEvent.ModifyBakingResult(bakingResult, textureGetter, modelBakery));
    }

    public static void onModelBake(ModelManager modelManager, ModelBakery.BakingResult bakingResult, ModelBakery modelBakery) {
        ModLoader.postEvent((Event)new ModelEvent.BakingCompleted(modelManager, bakingResult, modelBakery));
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, loc);
    }

    public static int computeQuadNormal(int[] vertices) {
        float nz;
        float dx1;
        float dx0;
        float ny;
        float dy0;
        float dz1;
        float x0 = Float.intBitsToFloat(vertices[IQuadTransformer.POSITION]);
        float y0 = Float.intBitsToFloat(vertices[IQuadTransformer.POSITION + 1]);
        float z0 = Float.intBitsToFloat(vertices[IQuadTransformer.POSITION + 2]);
        float x1 = Float.intBitsToFloat(vertices[IQuadTransformer.STRIDE + IQuadTransformer.POSITION]);
        float y1 = Float.intBitsToFloat(vertices[IQuadTransformer.STRIDE + IQuadTransformer.POSITION + 1]);
        float z1 = Float.intBitsToFloat(vertices[IQuadTransformer.STRIDE + IQuadTransformer.POSITION + 2]);
        float x2 = Float.intBitsToFloat(vertices[2 * IQuadTransformer.STRIDE + IQuadTransformer.POSITION]);
        float y2 = Float.intBitsToFloat(vertices[2 * IQuadTransformer.STRIDE + IQuadTransformer.POSITION + 1]);
        float z2 = Float.intBitsToFloat(vertices[2 * IQuadTransformer.STRIDE + IQuadTransformer.POSITION + 2]);
        float x3 = Float.intBitsToFloat(vertices[3 * IQuadTransformer.STRIDE + IQuadTransformer.POSITION]);
        float y3 = Float.intBitsToFloat(vertices[3 * IQuadTransformer.STRIDE + IQuadTransformer.POSITION + 1]);
        float dy1 = y2 - y0;
        float z3 = Float.intBitsToFloat(vertices[3 * IQuadTransformer.STRIDE + IQuadTransformer.POSITION + 2]);
        float dz0 = z3 - z1;
        float nx = dy1 * dz0 - (dz1 = z2 - z0) * (dy0 = y3 - y1);
        float length = Mth.sqrt((float)(nx * nx + (ny = dz1 * (dx0 = x3 - x1) - (dx1 = x2 - x0) * dz0) * ny + (nz = dx1 * dy0 - dy1 * dx0) * nz));
        if (length > 0.0f) {
            nx /= length;
            ny /= length;
            nz /= length;
        }
        int packedx = (byte)Math.round(nx * 127.0f) & 0xFF;
        int packedy = (byte)Math.round(ny * 127.0f) & 0xFF;
        int packedz = (byte)Math.round(nz * 127.0f) & 0xFF;
        return packedx | packedy << 8 | packedz << 16;
    }

    public static void fillNormal(int[] faceData) {
        int normal = ClientHooks.computeQuadNormal(faceData);
        for (int i = 0; i < 4; ++i) {
            faceData[i * 8 + 7] = normal;
        }
    }

    public static void loadEntityShader(@Nullable Entity entity, GameRenderer gameRenderer) {
        ResourceLocation shader;
        if (entity != null && (shader = EntitySpectatorShaderManager.get(entity.getType())) != null) {
            gameRenderer.setPostEffect(shader);
        }
    }

    public static boolean shouldCauseReequipAnimation(ItemStack from, ItemStack to, int slot) {
        boolean fromInvalid = from.isEmpty();
        boolean toInvalid = to.isEmpty();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.getItem().shouldCauseReequipAnimation(from, to, changed);
    }

    public static CustomizeGuiOverlayEvent.BossEventProgress onCustomizeBossEventProgress(GuiGraphics guiGraphics, Window window, LerpingBossEvent bossInfo, int x, int y, int increment) {
        CustomizeGuiOverlayEvent.BossEventProgress evt = new CustomizeGuiOverlayEvent.BossEventProgress(window, guiGraphics, Minecraft.getInstance().getDeltaTracker(), bossInfo, x, y, increment);
        NeoForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static ScreenshotEvent onScreenshot(NativeImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void onClientChangeGameType(PlayerInfo info, GameType currentGameMode, GameType newGameMode) {
        if (currentGameMode != newGameMode) {
            ClientPlayerChangeGameTypeEvent evt = new ClientPlayerChangeGameTypeEvent(info, currentGameMode, newGameMode);
            NeoForge.EVENT_BUS.post((Event)evt);
        }
    }

    public static void onMovementInputUpdate(Player player, ClientInput movementInput) {
        NeoForge.EVENT_BUS.post((Event)new MovementInputUpdateEvent(player, movementInput));
    }

    public static boolean onScreenMouseClickedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        ScreenEvent.MouseButtonPressed.Pre event = new ScreenEvent.MouseButtonPressed.Pre(guiScreen, mouseX, mouseY, button);
        return ((ScreenEvent.MouseButtonPressed.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenMouseClickedPost(Screen guiScreen, double mouseX, double mouseY, int button, boolean handled) {
        ScreenEvent.MouseButtonPressed.Post event = new ScreenEvent.MouseButtonPressed.Post(guiScreen, mouseX, mouseY, button, handled);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getClickResult();
    }

    public static boolean onScreenMouseReleasedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        ScreenEvent.MouseButtonReleased.Pre event = new ScreenEvent.MouseButtonReleased.Pre(guiScreen, mouseX, mouseY, button);
        return ((ScreenEvent.MouseButtonReleased.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenMouseReleasedPost(Screen guiScreen, double mouseX, double mouseY, int button, boolean handled) {
        ScreenEvent.MouseButtonReleased.Post event = new ScreenEvent.MouseButtonReleased.Post(guiScreen, mouseX, mouseY, button, handled);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getReleaseResult();
    }

    public static boolean onScreenMouseDragPre(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        ScreenEvent.MouseDragged.Pre event = new ScreenEvent.MouseDragged.Pre(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return ((ScreenEvent.MouseDragged.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onScreenMouseDragPost(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        ScreenEvent.MouseDragged.Post event = new ScreenEvent.MouseDragged.Post(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onScreenMouseScrollPre(MouseHandler mouseHelper, Screen guiScreen, double scrollDeltaX, double scrollDeltaY) {
        Window mainWindow = guiScreen.getMinecraft().getWindow();
        double mouseX = mouseHelper.xpos() * (double)mainWindow.getGuiScaledWidth() / (double)mainWindow.getScreenWidth();
        double mouseY = mouseHelper.ypos() * (double)mainWindow.getGuiScaledHeight() / (double)mainWindow.getScreenHeight();
        ScreenEvent.MouseScrolled.Pre event = new ScreenEvent.MouseScrolled.Pre(guiScreen, mouseX, mouseY, scrollDeltaX, scrollDeltaY);
        return ((ScreenEvent.MouseScrolled.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onScreenMouseScrollPost(MouseHandler mouseHelper, Screen guiScreen, double scrollDeltaX, double scrollDeltaY) {
        Window mainWindow = guiScreen.getMinecraft().getWindow();
        double mouseX = mouseHelper.xpos() * (double)mainWindow.getGuiScaledWidth() / (double)mainWindow.getScreenWidth();
        double mouseY = mouseHelper.ypos() * (double)mainWindow.getGuiScaledHeight() / (double)mainWindow.getScreenHeight();
        ScreenEvent.MouseScrolled.Post event = new ScreenEvent.MouseScrolled.Post(guiScreen, mouseX, mouseY, scrollDeltaX, scrollDeltaY);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onScreenKeyPressedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyPressed.Pre event = new ScreenEvent.KeyPressed.Pre(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyPressed.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenKeyPressedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyPressed.Post event = new ScreenEvent.KeyPressed.Post(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyPressed.Post)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenKeyReleasedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyReleased.Pre event = new ScreenEvent.KeyReleased.Pre(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyReleased.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenKeyReleasedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        ScreenEvent.KeyReleased.Post event = new ScreenEvent.KeyReleased.Post(guiScreen, keyCode, scanCode, modifiers);
        return ((ScreenEvent.KeyReleased.Post)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static boolean onScreenCharTypedPre(Screen guiScreen, char codePoint, int modifiers) {
        ScreenEvent.CharacterTyped.Pre event = new ScreenEvent.CharacterTyped.Pre(guiScreen, codePoint, modifiers);
        return ((ScreenEvent.CharacterTyped.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onScreenCharTypedPost(Screen guiScreen, char codePoint, int modifiers) {
        ScreenEvent.CharacterTyped.Post event = new ScreenEvent.CharacterTyped.Post(guiScreen, codePoint, modifiers);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onMouseButtonPre(int button, int action, int mods) {
        return ((InputEvent.MouseButton.Pre)NeoForge.EVENT_BUS.post((Event)new InputEvent.MouseButton.Pre(button, action, mods))).isCanceled();
    }

    public static void onMouseButtonPost(int button, int action, int mods) {
        NeoForge.EVENT_BUS.post((Event)new InputEvent.MouseButton.Post(button, action, mods));
    }

    public static boolean onMouseScroll(MouseHandler mouseHelper, double scrollDeltaX, double scrollDeltaY) {
        InputEvent.MouseScrollingEvent event = new InputEvent.MouseScrollingEvent(scrollDeltaX, scrollDeltaY, mouseHelper.isLeftPressed(), mouseHelper.isMiddlePressed(), mouseHelper.isRightPressed(), mouseHelper.xpos(), mouseHelper.ypos());
        return ((InputEvent.MouseScrollingEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
    }

    public static void onKeyInput(int key, int scanCode, int action, int modifiers) {
        NeoForge.EVENT_BUS.post((Event)new InputEvent.Key(key, scanCode, action, modifiers));
    }

    public static InputEvent.InteractionKeyMappingTriggered onClickInput(int button, KeyMapping keyBinding, InteractionHand hand) {
        InputEvent.InteractionKeyMappingTriggered event = new InputEvent.InteractionKeyMappingTriggered(button, keyBinding, hand);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean isNameplateInRenderDistance(LivingEntity entity, double squareDistance) {
        double value = entity.getAttributeValue(NeoForgeMod.NAMETAG_DISTANCE);
        return !(squareDistance > value * value);
    }

    public static boolean shouldRenderEffect(MobEffectInstance effectInstance) {
        return IClientMobEffectExtensions.of(effectInstance).isVisibleInInventory(effectInstance);
    }

    public static void registerLayerDefinition(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
        layerDefinitions.put(layerLocation, supplier);
    }

    public static void loadLayerDefinitions(ImmutableMap.Builder<ModelLayerLocation, LayerDefinition> builder) {
        layerDefinitions.forEach((k, v) -> builder.put(k, (Object)((LayerDefinition)v.get())));
    }

    @Nullable
    public static SkullModelBase getModdedSkullModel(EntityModelSet modelSet, SkullBlock.Type type) {
        return skullModelsByType.getOrDefault(type, set -> null).apply(modelSet);
    }

    public static void firePlayerLogin(MultiPlayerGameMode pc, LocalPlayer player, Connection networkManager) {
        NeoForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggingIn(pc, player, networkManager));
    }

    public static void firePlayerLogout(@Nullable MultiPlayerGameMode pc, @Nullable LocalPlayer player) {
        NeoForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggingOut(pc, player, player != null ? (player.connection != null ? player.connection.getConnection() : null) : null));
    }

    public static void firePlayerRespawn(MultiPlayerGameMode pc, LocalPlayer oldPlayer, LocalPlayer newPlayer, Connection networkManager) {
        NeoForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.Clone(pc, oldPlayer, newPlayer, networkManager));
    }

    public static void onRegisterParticleProviders(ParticleEngine particleEngine) {
        ModLoader.postEvent((Event)new RegisterParticleProvidersEvent(particleEngine));
    }

    public static void onRegisterKeyMappings(Options options) {
        ModLoader.postEvent((Event)new RegisterKeyMappingsEvent(options));
    }

    @Nullable
    public static Component onClientChat(ChatType.Bound boundChatType, Component message, UUID sender) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(boundChatType, message, sender);
        return ((ClientChatReceivedEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? null : event.getMessage();
    }

    @Nullable
    public static Component onClientPlayerChat(ChatType.Bound boundChatType, Component message, PlayerChatMessage playerChatMessage, UUID sender) {
        ClientChatReceivedEvent.Player event = new ClientChatReceivedEvent.Player(boundChatType, message, playerChatMessage, sender);
        return ((ClientChatReceivedEvent.Player)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? null : event.getMessage();
    }

    @Nullable
    public static Component onClientSystemChat(Component message, boolean overlay) {
        ClientChatReceivedEvent.System event = new ClientChatReceivedEvent.System(message, overlay);
        return ((ClientChatReceivedEvent.System)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? null : event.getMessage();
    }

    public static String onClientSendMessage(String message) {
        ClientChatEvent event = new ClientChatEvent(message);
        return ((ClientChatEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? "" : event.getMessage();
    }

    @ApiStatus.Internal
    public static void handleUpdateRecipes(ClientPacketListener packetListener, Consumer<FuelValues> fuelValuesSetter) {
        if (packetListener.getConnectionType().isNeoForge()) {
            fuelValuesSetter.accept(DataMapHooks.populateFuelValues((RegistryAccess)packetListener.registryAccess(), packetListener.enabledFeatures()));
        } else {
            RecipesReceivedEvent event = new RecipesReceivedEvent(Set.of(), RecipeMap.create(List.of()));
            NeoForge.EVENT_BUS.post((Event)event);
        }
    }

    public static Font getTooltipFont(ItemStack stack, Font fallbackFont) {
        Font stackFont = IClientItemExtensions.of(stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
        return stackFont == null ? fallbackFont : stackFont;
    }

    public static RenderTooltipEvent.Pre onRenderTooltipPre(ItemStack stack, GuiGraphics graphics, int x, int y, int screenWidth, int screenHeight, List<ClientTooltipComponent> components, Font fallbackFont, ClientTooltipPositioner positioner) {
        RenderTooltipEvent.Pre preEvent = new RenderTooltipEvent.Pre(stack, graphics, x, y, screenWidth, screenHeight, ClientHooks.getTooltipFont(stack, fallbackFont), components, positioner);
        NeoForge.EVENT_BUS.post((Event)preEvent);
        return preEvent;
    }

    public static RenderTooltipEvent.Texture onRenderTooltipTexture(ItemStack stack, GuiGraphics graphics, int x, int y, Font font, List<ClientTooltipComponent> components, @Nullable ResourceLocation texture) {
        return (RenderTooltipEvent.Texture)NeoForge.EVENT_BUS.post((Event)new RenderTooltipEvent.Texture(stack, graphics, x, y, font, components, texture));
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        return ClientHooks.gatherTooltipComponents(stack, textElements, Optional.empty(), mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        return ClientHooks.gatherTooltipComponentsFromElements(stack, elements, mouseX, screenWidth, screenHeight, fallbackFont);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponentsFromElements(ItemStack stack, List<Either<FormattedText, TooltipComponent>> elements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ClientHooks.getTooltipFont(stack, fallbackFont);
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(stack, screenWidth, screenHeight, elements, -1);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> ClientHooks.splitLine(text, font, tooltipTextWidthF), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList();
        }
        return event.getTooltipElements().stream().map(either -> (ClientTooltipComponent)either.map(text -> ClientTooltipComponent.create((FormattedCharSequence)(text instanceof Component ? ((Component)text).getVisualOrderText() : Language.getInstance().getVisualOrder(text))), ClientTooltipComponent::create)).toList();
    }

    private static Stream<ClientTooltipComponent> splitLine(FormattedText text, Font font, int maxWidth) {
        Component component;
        if (text instanceof Component && (component = (Component)text).getString().isEmpty()) {
            return Stream.of(component.getVisualOrderText()).map(ClientTooltipComponent::create);
        }
        return font.split(text, maxWidth).stream().map(ClientTooltipComponent::create);
    }

    public static Comparator<ParticleRenderType> makeParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderType)typeOne, (ParticleRenderType)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }

    public static ScreenEvent.RenderInventoryMobEffects onScreenPotionSize(Screen screen, int availableSpace, boolean compact, int horizontalOffset) {
        ScreenEvent.RenderInventoryMobEffects event = new ScreenEvent.RenderInventoryMobEffects(screen, availableSpace, compact, horizontalOffset);
        NeoForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean onToastAdd(Toast toast) {
        return ((ToastAddEvent)NeoForge.EVENT_BUS.post((Event)new ToastAddEvent(toast))).isCanceled();
    }

    public static boolean renderFireOverlay(Player player, PoseStack mat) {
        return ClientHooks.renderBlockOverlay(player, mat, RenderBlockScreenEffectEvent.OverlayType.FIRE, Blocks.FIRE.defaultBlockState(), player.blockPosition());
    }

    public static boolean renderWaterOverlay(Player player, PoseStack mat) {
        return ClientHooks.renderBlockOverlay(player, mat, RenderBlockScreenEffectEvent.OverlayType.WATER, Blocks.WATER.defaultBlockState(), player.blockPosition());
    }

    public static boolean renderBlockOverlay(Player player, PoseStack mat, RenderBlockScreenEffectEvent.OverlayType type, BlockState block, BlockPos pos) {
        return ((RenderBlockScreenEffectEvent)NeoForge.EVENT_BUS.post((Event)new RenderBlockScreenEffectEvent(player, mat, type, block, pos))).isCanceled();
    }

    public static int getMaxMipmapLevel(int width, int height) {
        return Math.min(Mth.log2((int)Math.max(1, width)), Mth.log2((int)Math.max(1, height)));
    }

    @ApiStatus.Internal
    public static <T extends BlockEntity> boolean isBlockEntityRendererVisible(BlockEntityRenderDispatcher dispatcher, BlockEntity blockEntity, Frustum frustum) {
        BlockEntityRenderer renderer = dispatcher.getRenderer(blockEntity);
        return renderer != null && frustum.isVisible(renderer.getRenderBoundingBox(blockEntity));
    }

    public static List<BlockElement> fixItemModelSeams(List<BlockElement> elements, TextureAtlasSprite sprite) {
        float expand = -sprite.uvShrinkRatio();
        elements.replaceAll(element -> {
            if (element.faces().size() != 1) {
                return element;
            }
            Map.Entry faceEntry = element.faces().entrySet().iterator().next();
            if (((Direction)faceEntry.getKey()).getAxis() == Direction.Axis.Z) {
                return element;
            }
            Vector3f from = new Vector3f(Mth.clamp((float)Mth.lerp((float)expand, (float)element.from().x(), (float)8.0f), (float)0.0f, (float)16.0f), Mth.clamp((float)Mth.lerp((float)expand, (float)element.from().y(), (float)8.0f), (float)0.0f, (float)16.0f), element.from().z());
            Vector3f to = new Vector3f(Mth.clamp((float)Mth.lerp((float)expand, (float)element.to().x(), (float)8.0f), (float)0.0f, (float)16.0f), Mth.clamp((float)Mth.lerp((float)expand, (float)element.to().y(), (float)8.0f), (float)0.0f, (float)16.0f), element.to().z());
            BlockElementFace face = (BlockElementFace)faceEntry.getValue();
            BlockElementFace.UVs uvs = face.uvs();
            if (uvs == null) {
                uvs = FaceBakery.defaultFaceUV((Vector3fc)element.from(), (Vector3fc)element.to(), (Direction)((Direction)faceEntry.getKey()));
            }
            float minU = uvs.minU();
            float minV = uvs.minV();
            float maxU = uvs.maxU();
            float maxV = uvs.maxV();
            if (((Direction)faceEntry.getKey()).getAxis() == Direction.Axis.Y) {
                float centerU = (minU + minU + maxU + maxU) / 4.0f;
                minU = Mth.clamp((float)Mth.lerp((float)expand, (float)minU, (float)centerU), (float)0.0f, (float)16.0f);
                maxU = Mth.clamp((float)Mth.lerp((float)expand, (float)maxU, (float)centerU), (float)0.0f, (float)16.0f);
            } else {
                float centerV = (minV + minV + maxV + maxV) / 4.0f;
                minV = Mth.clamp((float)Mth.lerp((float)expand, (float)minV, (float)centerV), (float)0.0f, (float)16.0f);
                maxV = Mth.clamp((float)Mth.lerp((float)expand, (float)maxV, (float)centerV), (float)0.0f, (float)16.0f);
            }
            uvs = new BlockElementFace.UVs(minU, minV, maxU, maxV);
            face = new BlockElementFace(face.cullForDirection(), face.tintIndex(), face.texture(), uvs, face.rotation(), face.faceData(), new MutableObject());
            return new BlockElement((Vector3fc)from, (Vector3fc)to, Map.of((Direction)faceEntry.getKey(), face), element.rotation(), element.shade(), element.lightEmission(), element.faceData());
        });
        return elements;
    }

    public static List<AddSectionGeometryEvent.AdditionalSectionRenderer> gatherAdditionalRenderers(BlockPos sectionOrigin, Level level) {
        AddSectionGeometryEvent event = new AddSectionGeometryEvent(sectionOrigin, level);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getAdditionalRenderers();
    }

    public static void addAdditionalGeometry(List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers, Function<RenderType, VertexConsumer> getOrCreateBuilder, RenderChunkRegion region, PoseStack transformation) {
        if (additionalRenderers.isEmpty()) {
            return;
        }
        AddSectionGeometryEvent.SectionRenderingContext context = new AddSectionGeometryEvent.SectionRenderingContext(getOrCreateBuilder, (BlockAndTintGetter)region, transformation);
        for (AddSectionGeometryEvent.AdditionalSectionRenderer renderer : additionalRenderers) {
            renderer.render(context);
        }
    }

    @ApiStatus.Internal
    public static void initClientHooks(Minecraft mc, ReloadableResourceManager resourceManager) {
        if (initializedClientHooks) {
            throw new IllegalStateException("Client hooks initialized more than once");
        }
        initializedClientHooks = true;
        ClientExtensionsManager.init();
        MenuScreens.init();
        ClientHooks.initClientRegistries();
        AddClientReloadListenersEvent rlEvent = new AddClientReloadListenersEvent(resourceManager);
        ModLoader.postEvent((Event)rlEvent);
        resourceManager.updateListenersFrom((SortedReloadListenerEvent)rlEvent);
        ModLoader.postEvent((Event)new EntityRenderersEvent.RegisterLayerDefinitions());
        ModLoader.postEvent((Event)new EntityRenderersEvent.CreateSkullModels(skullModelsByType));
        ModLoader.postEvent((Event)new EntityRenderersEvent.RegisterRenderers());
        ModLoader.postEvent((Event)new RegisterRenderStateModifiersEvent());
        ClientTooltipComponentManager.init();
        EntitySpectatorShaderManager.init();
        RecipeBookManager.init();
        mc.gui.initModdedOverlays();
        DimensionSpecialEffectsManager.init();
        NamedRenderTypeManager.init();
        ColorResolverManager.init();
        ItemDecoratorHandler.init();
        PresetEditorManager.init();
        MapDecorationRendererManager.init();
        DimensionTransitionScreenManager.init();
        RenderPipelines.registerCustomPipelines();
        PipelineModifiers.init();
    }

    public static void initClientRegistries() {
        if (initializedClientRegistries) {
            throw new IllegalStateException("Client registries initialized more than once");
        }
        initializedClientRegistries = true;
        AnimationTypeManager.init();
        BlockStateModelHooks.init();
        ModLoader.postEvent((Event)new InitializeClientRegistriesEvent());
    }

    public static void fireRenderFramePre(DeltaTracker partialTick) {
        NeoForge.EVENT_BUS.post((Event)new RenderFrameEvent.Pre(partialTick));
    }

    public static void fireRenderFramePost(DeltaTracker partialTick) {
        NeoForge.EVENT_BUS.post((Event)new RenderFrameEvent.Post(partialTick));
        RenderSystem.ensurePipelineModifiersEmpty();
    }

    public static void fireResourceLoadFinishedEvent(boolean initial) {
        NeoForge.EVENT_BUS.post((Event)new ClientResourceLoadFinishedEvent(initial));
    }

    public static void fireClientTickPre() {
        NeoForge.EVENT_BUS.post((Event)new ClientTickEvent.Pre());
    }

    public static void fireClientTickPost() {
        NeoForge.EVENT_BUS.post((Event)new ClientTickEvent.Post());
    }

    public static List<Component> getEffectTooltip(AbstractContainerScreen<?> screen, MobEffectInstance effectInst, List<Component> tooltip) {
        GatherEffectScreenTooltipsEvent event = new GatherEffectScreenTooltipsEvent(screen, effectInst, tooltip);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getTooltip();
    }

    public static RecipeBookType[] getFilteredRecipeBookTypeValues() {
        ClientPacketListener listener = Minecraft.getInstance().getConnection();
        if (listener != null && !listener.getConnection().isMemoryConnection() && listener.getConnectionType().isOther()) {
            if (cachedFilteredTypes == null) {
                cachedFilteredTypes = RECIPE_BOOK_TYPE_EXTENSION_INFO.extended() ? Arrays.copyOfRange(RECIPE_BOOK_TYPES, 0, RECIPE_BOOK_TYPE_EXTENSION_INFO.vanillaCount()) : RECIPE_BOOK_TYPES;
            }
            return cachedFilteredTypes;
        }
        return RECIPE_BOOK_TYPES;
    }

    public static boolean isInTranslucentBlockOutlinePass(Level level, BlockPos pos, BlockState state) {
        OUTLINE_PASS_RANDOM.setSeed(42L);
        OUTLINE_PART_SCRATCH_LIST.clear();
        BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        model.collectParts((BlockAndTintGetter)level, pos, state, OUTLINE_PASS_RANDOM, OUTLINE_PART_SCRATCH_LIST);
        for (BlockModelPart part : OUTLINE_PART_SCRATCH_LIST) {
            RenderType renderType = part.getRenderType(state);
            if (renderType != RenderType.translucent() && renderType != RenderType.tripwire()) continue;
            return true;
        }
        return false;
    }

    public static void reloadRenderer() {
        Minecraft.getInstance().levelRenderer.allChanged();
    }

    public static Map<ResourceLocation, ResourceLocation> gatherMaterialAtlases(Map<ResourceLocation, ResourceLocation> vanillaAtlases) {
        vanillaAtlases = new HashMap<ResourceLocation, ResourceLocation>(vanillaAtlases);
        ModLoader.postEvent((Event)new RegisterMaterialAtlasesEvent(vanillaAtlases));
        return Map.copyOf(vanillaAtlases);
    }

    @ApiStatus.Internal
    public static FrameGraphSetupEvent fireFrameGraphSetup(FrameGraphBuilder builder, LevelTargetBundle targets, RenderTargetDescriptor renderTargetDescriptor, Frustum frustum, Camera camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, DeltaTracker deltaTracker, ProfilerFiller profiler) {
        return (FrameGraphSetupEvent)NeoForge.EVENT_BUS.post((Event)new FrameGraphSetupEvent(builder, targets, renderTargetDescriptor, frustum, camera, modelViewMatrix, projectionMatrix, deltaTracker, profiler));
    }

    @ApiStatus.Internal
    public static MainTarget instantiateMainTarget(int width, int height) {
        ConfigureMainRenderTargetEvent e = (ConfigureMainRenderTargetEvent)ModLoader.postEventWithReturn((Event)new ConfigureMainRenderTargetEvent());
        return new MainTarget(width, height, e.isStencilEnabled());
    }

    @ApiStatus.Internal
    public static TextureFormat getStencilFormat() {
        boolean reducedPrecision = NeoForgeClientConfig.INSTANCE.reducedDepthStencilFormat.getAsBoolean();
        return reducedPrecision ? TextureFormat.DEPTH24_STENCIL8 : TextureFormat.DEPTH32_STENCIL8;
    }

    @ApiStatus.Internal
    public static Overlay createLoadingOverlay(Minecraft minecraft, ReloadInstance reloadInstance, Consumer<Optional<Throwable>> errorHandler, boolean fadeIn) {
        EarlyLoadingScreenController earlyLoadingScreenController = EarlyLoadingScreenController.current();
        if (earlyLoadingScreenController instanceof DisplayWindow) {
            DisplayWindow displayWindow = (DisplayWindow)earlyLoadingScreenController;
            return new NeoForgeLoadingOverlay(minecraft, reloadInstance, errorHandler, displayWindow);
        }
        return new LoadingOverlay(minecraft, reloadInstance, errorHandler, fadeIn);
    }
}

