/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.network.payload.ConfigFilePayload;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ConfigSync {
    private ConfigSync() {
    }

    public static List<ConfigFilePayload> syncConfigs() {
        Map<String, byte[]> configData = ModConfigs.getConfigSet((ModConfig.Type)ModConfig.Type.SERVER).stream().collect(Collectors.toMap(ModConfig::getFileName, mc -> {
            try {
                return Files.readAllBytes(mc.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return configData.entrySet().stream().map(e -> new ConfigFilePayload((String)e.getKey(), (byte[])e.getValue())).toList();
    }

    public static void receiveSyncedConfig(byte[] contents, String fileName) {
        Optional.ofNullable((ModConfig)ModConfigs.getFileMap().get(fileName)).ifPresent(mc -> ConfigTracker.acceptSyncedConfig((ModConfig)mc, (byte[])contents));
    }
}

