/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.loading;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.earlydisplay.DisplayWindow;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;

public class NeoForgeLoadingOverlay
extends LoadingOverlay {
    public static final ResourceLocation LOADING_OVERLAY_TEXTURE_ID = ResourceLocation.parse((String)"neoforge:loading_overlay");
    private final Minecraft minecraft;
    private final ReloadInstance reload;
    private final Consumer<Optional<Throwable>> onFinish;
    private final DisplayWindow displayWindow;
    private final ProgressMeter progressMeter;
    private final GpuTexture framebuffer;
    private float currentProgress;
    private long fadeOutStart = -1L;

    public NeoForgeLoadingOverlay(Minecraft mc, ReloadInstance reloader, Consumer<Optional<Throwable>> errorConsumer, DisplayWindow displayWindow) {
        super(mc, reloader, errorConsumer, false);
        this.minecraft = mc;
        this.reload = reloader;
        this.onFinish = errorConsumer;
        this.displayWindow = displayWindow;
        GlTexture logoGpuTexture = (GlTexture)mc.getTextureManager().getTexture(MOJANG_STUDIOS_LOGO_LOCATION).getTexture();
        displayWindow.addMojangTexture(logoGpuTexture.glId());
        this.progressMeter = StartupNotificationManager.prependProgressBar((String)"Minecraft Progress", (int)1000);
        this.framebuffer = ((GlDevice)RenderSystem.getDevice()).createExternalTexture("loading overlay framebuffer", displayWindow.getFramebufferTextureId());
        Minecraft.getInstance().getTextureManager().register(LOADING_OVERLAY_TEXTURE_ID, (AbstractTexture)new ExternalTexture(this.framebuffer));
    }

    public static Supplier<LoadingOverlay> newInstance(Supplier<Minecraft> mc, Supplier<ReloadInstance> ri, Consumer<Optional<Throwable>> handler, DisplayWindow window) {
        return () -> new NeoForgeLoadingOverlay((Minecraft)mc.get(), (ReloadInstance)ri.get(), handler, window);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        long millis = Util.getMillis();
        float fadeouttimer = this.fadeOutStart > -1L ? (float)(millis - this.fadeOutStart) / 1000.0f : -1.0f;
        this.currentProgress = Mth.clamp((float)(this.currentProgress * 0.95f + this.reload.getActualProgress() * 0.05f), (float)0.0f, (float)1.0f);
        this.progressMeter.setAbsolute(Mth.ceil((float)(this.currentProgress * 1000.0f)));
        graphics.flush();
        this.displayWindow.renderToFramebuffer();
        int fbWidth = this.minecraft.getWindow().getWidth();
        int fbHeight = this.minecraft.getWindow().getHeight();
        float fade = 1.0f - Mth.clamp((float)(fadeouttimer - 1.0f), (float)0.0f, (float)1.0f);
        if (fadeouttimer >= 1.0f && this.minecraft.screen != null) {
            this.minecraft.screen.render(graphics, 0, 0, partialTick);
        }
        int width = this.minecraft.getWindow().getGuiScaledWidth();
        int height = this.minecraft.getWindow().getGuiScaledHeight();
        int color = ARGB.colorFromFloat((float)fade, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(RenderType::guiTexturedOverlay, LOADING_OVERLAY_TEXTURE_ID, 0, 0, 0.0f, 0.0f, fbWidth, fbHeight, fbWidth, fbHeight, width, height, color);
        if (fadeouttimer >= 2.0f) {
            this.progressMeter.complete();
            graphics.flush();
            Minecraft.getInstance().getTextureManager().release(LOADING_OVERLAY_TEXTURE_ID);
            this.minecraft.setOverlay(null);
            this.displayWindow.close();
        }
        if (this.fadeOutStart == -1L && this.reload.isDone()) {
            this.fadeOutStart = Util.getMillis();
            try {
                this.reload.checkExceptions();
                this.onFinish.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.onFinish.accept(Optional.of(throwable));
            }
            if (this.minecraft.screen != null) {
                this.minecraft.screen.init(this.minecraft, graphics.guiWidth(), graphics.guiHeight());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ExternalTexture
    extends AbstractTexture {
        public ExternalTexture(GpuTexture texture) {
            this.texture = texture;
            this.setFilter(false, false);
        }
    }
}

