/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.resource;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.resource.EmptyPackResources;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.ApiStatus;

public class ResourcePackLoader {
    public static final String MOD_DATA_ID = "mod_data";
    public static final String MOD_RESOURCES_ID = "mod_resources";
    private static Map<IModFile, Pack.ResourcesSupplier> modResourcePacks;
    private static final Logger LOGGER;
    private static final PackSelectionConfig MOD_PACK_SELECTION_CONFIG;
    public static final MetadataSectionType<PackMetadataSection> OPTIONAL_FORMAT;

    public static Optional<Pack.ResourcesSupplier> getPackFor(String modId) {
        return Optional.ofNullable(ModList.get().getModFileById(modId)).map(IModFileInfo::getFile).map(mf -> modResourcePacks.get(mf));
    }

    public static void populatePackRepository(PackRepository resourcePacks, PackType packType, boolean trusted) {
        ResourcePackLoader.findResourcePacks();
        resourcePacks.addPackFinder(ResourcePackLoader.buildPackFinder(modResourcePacks, packType));
        ModLoader.postEvent((Event)new AddPackFindersEvent(packType, arg_0 -> ((PackRepository)resourcePacks).addPackFinder(arg_0), trusted));
    }

    private static synchronized void findResourcePacks() {
        if (modResourcePacks == null) {
            modResourcePacks = ModList.get().getModFiles().stream().filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(mf -> Pair.of((Object)mf, (Object)ResourcePackLoader.createPackForMod(mf))).collect(Collectors.toMap(p -> ((IModFileInfo)p.getFirst()).getFile(), Pair::getSecond, (u, v) -> {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Duplicate key %s", u));
            }, LinkedHashMap::new));
        }
    }

    public static RepositorySource buildPackFinder(Map<IModFile, Pack.ResourcesSupplier> modResourcePacks, PackType packType) {
        return packAcceptor -> ResourcePackLoader.packFinder(modResourcePacks, packAcceptor, packType);
    }

    private static void packFinder(Map<IModFile, Pack.ResourcesSupplier> modResourcePacks, Consumer<Pack> packAcceptor, PackType packType) {
        ArrayList<Pack> hiddenPacks = new ArrayList<Pack>();
        for (Map.Entry<IModFile, Pack.ResourcesSupplier> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if ("minecraft".equals(mod.getModId())) continue;
            String name = "mod/" + e.getKey().getModInfos().stream().map(IModInfo::getModId).collect(Collectors.joining(","));
            String version = e.getKey().getModInfos().stream().map(IModInfo::getVersion).map(ArtifactVersion::toString).collect(Collectors.joining(","));
            String packName = e.getKey().getFileName();
            try {
                Pack modPack;
                boolean isRequired;
                PackLocationInfo locationInfo = new PackLocationInfo(name, (Component)Component.literal((String)(packName.isEmpty() ? "[unnamed]" : packName)), PackSource.DEFAULT, Optional.of(new KnownPack("neoforge", name, version)));
                boolean bl = isRequired = packType == PackType.CLIENT_RESOURCES && mod.getOwningFile().showAsResourcePack() || packType == PackType.SERVER_DATA && mod.getOwningFile().showAsDataPack();
                if (isRequired) {
                    modPack = Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)e.getValue(), (PackType)packType, (PackSelectionConfig)MOD_PACK_SELECTION_CONFIG);
                    if (modPack == null) {
                        ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.warning((String)"fml.modloading.brokenresources", (Object[])new Object[]{e.getKey()}).withAffectedMod(mod));
                        continue;
                    }
                } else {
                    modPack = ResourcePackLoader.readWithOptionalMeta(locationInfo, e.getValue(), packType, MOD_PACK_SELECTION_CONFIG);
                }
                if (isRequired) {
                    packAcceptor.accept(modPack);
                    continue;
                }
                hiddenPacks.add(modPack.hidden());
            }
            catch (IOException exception) {
                LOGGER.error("Failed to read pack.mcmeta file of mod {}", (Object)mod.getModId(), (Object)exception);
                ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.warning((String)"fml.modloading.brokenresources", (Object[])new Object[]{e.getKey()}).withAffectedMod(mod).withCause((Throwable)exception));
            }
        }
        packAcceptor.accept(ResourcePackLoader.makePack(packType, hiddenPacks));
    }

    public static Pack readWithOptionalMeta(PackLocationInfo location, Pack.ResourcesSupplier resources, PackType type, PackSelectionConfig selectionConfig) throws IOException {
        Pack.Metadata packInfo = ResourcePackLoader.readMeta(type, location, resources);
        return new Pack(location, resources, packInfo, selectionConfig);
    }

    private static Pack.Metadata readMeta(PackType type, PackLocationInfo location, Pack.ResourcesSupplier resources) throws IOException {
        int currentVersion = SharedConstants.getCurrentVersion().getPackVersion(type);
        try (PackResources primaryResources = resources.openPrimary(location);){
            PackMetadataSection metadata = (PackMetadataSection)primaryResources.getMetadataSection(OPTIONAL_FORMAT);
            FeatureFlagSet flags = Optional.ofNullable((FeatureFlagsMetadataSection)primaryResources.getMetadataSection(FeatureFlagsMetadataSection.TYPE)).map(FeatureFlagsMetadataSection::flags).orElse(FeatureFlagSet.of());
            List vanillaOverlays = Optional.ofNullable((OverlayMetadataSection)primaryResources.getMetadataSection(OverlayMetadataSection.TYPE)).map(section -> section.overlaysForVersion(currentVersion)).orElse(List.of());
            List neoOverlays = Optional.ofNullable((OverlayMetadataSection)primaryResources.getMetadataSection(OverlayMetadataSection.NEOFORGE_TYPE)).map(section -> section.overlaysForVersion(currentVersion)).orElse(List.of());
            List overlays = new ArrayList(vanillaOverlays);
            overlays.addAll(neoOverlays);
            overlays = List.copyOf(overlays);
            if (metadata == null) {
                Pack.Metadata metadata2 = new Pack.Metadata(location.title(), PackCompatibility.COMPATIBLE, flags, overlays, primaryResources.isHidden());
                return metadata2;
            }
            PackCompatibility compatibility = metadata.packFormat() == -1 && metadata.supportedFormats().isEmpty() ? PackCompatibility.COMPATIBLE : PackCompatibility.forVersion((InclusiveRange)Pack.getDeclaredPackVersions((String)location.id(), (PackMetadataSection)metadata), (int)currentVersion);
            Pack.Metadata metadata3 = new Pack.Metadata(metadata.description(), compatibility, flags, overlays, primaryResources.isHidden());
            return metadata3;
        }
    }

    private static Pack makePack(PackType packType, ArrayList<Pack> hiddenPacks) {
        String id = packType == PackType.CLIENT_RESOURCES ? MOD_RESOURCES_ID : MOD_DATA_ID;
        String name = packType == PackType.CLIENT_RESOURCES ? "Mod Resources" : "Mod Data";
        String descriptionKey = packType == PackType.CLIENT_RESOURCES ? "fml.resources.modresources" : "fml.resources.moddata";
        return Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(id, (Component)Component.literal((String)name), PackSource.DEFAULT, Optional.empty()), (Pack.ResourcesSupplier)new EmptyPackResources.EmptyResourcesSupplier(new PackMetadataSection((Component)Component.translatable((String)descriptionKey, (Object[])new Object[]{hiddenPacks.size()}), SharedConstants.getCurrentVersion().getPackVersion(packType))), (PackType)packType, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false)).withChildren(hiddenPacks);
    }

    public static Pack.ResourcesSupplier createPackForMod(IModFileInfo mf) {
        return new PathPackResources.PathResourcesSupplier(mf.getFile().getSecureJar().getRootPath());
    }

    public static List<String> getPackNames(PackType packType) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(ModList.get().getModFiles().stream().filter(packType == PackType.CLIENT_RESOURCES ? IModFileInfo::showAsResourcePack : IModFileInfo::showAsDataPack).filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(IModFileInfo::getFile).map(mf -> "mod/" + mf.getModInfos().stream().map(IModInfo::getModId).collect(Collectors.joining())).toList());
        ids.add(packType == PackType.CLIENT_RESOURCES ? MOD_RESOURCES_ID : MOD_DATA_ID);
        return ids;
    }

    @ApiStatus.Internal
    public static List<Pack> expandAndRemoveRootChildren(Stream<Pack> packs, Collection<Pack> availablePacks) {
        HashSet hiddenSubPacks = Sets.newHashSet();
        for (Pack pack : availablePacks) {
            if (!pack.isRequired()) continue;
            hiddenSubPacks.addAll(pack.getChildren());
        }
        LinkedHashSet<Pack> orderedPackSet = new LinkedHashSet<Pack>();
        Iterator iterator = packs.iterator();
        while (iterator.hasNext()) {
            Pack rootPack = (Pack)iterator.next();
            if (rootPack.isHidden() && (orderedPackSet.contains(rootPack) || hiddenSubPacks.contains(rootPack))) continue;
            orderedPackSet.addLast(rootPack);
            for (Pack pack : rootPack.getChildren()) {
                orderedPackSet.addLast(pack);
            }
        }
        return new ArrayList<Pack>(orderedPackSet);
    }

    @ApiStatus.Internal
    public static void reorderNewlyDiscoveredPacks(Collection<String> set, Collection<String> old, PackRepository packRepository) {
        LinkedHashSet added = Sets.newLinkedHashSet(set);
        LinkedHashSet oldSet = Sets.newLinkedHashSet(old);
        set.clear();
        ArrayList<String> newOrder = new ArrayList<String>();
        for (String s : added) {
            Pack pack = packRepository.getPack(s);
            if (!oldSet.contains(s) && pack != null && pack.getDefaultPosition() == Pack.Position.BOTTOM) {
                newOrder.add(0, s);
                continue;
            }
            newOrder.add(s);
        }
        set.addAll(newOrder);
    }

    static {
        LOGGER = LogManager.getLogger();
        MOD_PACK_SELECTION_CONFIG = new PackSelectionConfig(false, Pack.Position.TOP, false);
        OPTIONAL_FORMAT = new MetadataSectionType("pack", RecordCodecBuilder.create(in -> in.group((App)ComponentSerialization.CODEC.optionalFieldOf("description", (Object)Component.empty()).forGetter(PackMetadataSection::description), (App)Codec.INT.optionalFieldOf("pack_format", (Object)-1).forGetter(PackMetadataSection::packFormat), (App)InclusiveRange.codec((Codec)Codec.INT).optionalFieldOf("supported_formats").forGetter(PackMetadataSection::supportedFormats)).apply((Applicative)in, PackMetadataSection::new)));
    }
}

