/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event.entity.living;

import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

public class LivingShieldBlockEvent
extends LivingEvent
implements ICancellableEvent {
    private final DamageContainer container;
    private float dmgBlocked;
    private final float originalDmgBlocked;
    private int shieldDamage = -1;
    private final boolean originalBlocked;
    private boolean newBlocked;

    public LivingShieldBlockEvent(LivingEntity blocker, DamageContainer container, float blockedDamage, boolean originalBlockedState) {
        super(blocker);
        this.container = container;
        this.originalDmgBlocked = this.dmgBlocked = blockedDamage;
        this.originalBlocked = originalBlockedState;
        this.newBlocked = originalBlockedState;
    }

    public DamageContainer getDamageContainer() {
        return this.container;
    }

    public DamageSource getDamageSource() {
        return this.getDamageContainer().getSource();
    }

    public float getOriginalBlockedDamage() {
        return this.originalDmgBlocked;
    }

    public float getBlockedDamage() {
        return Math.min(this.dmgBlocked, this.container.getNewDamage());
    }

    public int shieldDamage() {
        if (this.newBlocked) {
            return this.shieldDamage;
        }
        return 0;
    }

    public void setBlockedDamage(float blocked) {
        this.dmgBlocked = Mth.clamp((float)blocked, (float)0.0f, (float)this.container.getNewDamage());
    }

    public void setShieldDamage(int damage) {
        this.shieldDamage = damage;
    }

    public boolean getOriginalBlock() {
        return this.originalBlocked;
    }

    public boolean getBlocked() {
        return this.newBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.newBlocked = isBlocked;
    }
}

