/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.access;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.transfer.RangedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.access.HandlerItemAccess;
import net.neoforged.neoforge.transfer.access.InfiniteMaterialsItemAccess;
import net.neoforged.neoforge.transfer.access.OneByOneItemAccess;
import net.neoforged.neoforge.transfer.access.PlayerItemAccess;
import net.neoforged.neoforge.transfer.access.StackItemAccess;
import net.neoforged.neoforge.transfer.item.CarriedSlotWrapper;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.PlayerInventoryWrapper;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface ItemAccess {
    public static ItemAccess forPlayerInteraction(Player player, InteractionHand hand) {
        if (player.hasInfiniteMaterials()) {
            return ItemAccess.forInfiniteMaterials(player, player.getItemInHand(hand));
        }
        return ItemAccess.forPlayerSlot(player, switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> player.getInventory().getSelectedSlot();
            case InteractionHand.OFF_HAND -> 40;
        });
    }

    public static ItemAccess forInfiniteMaterials(Player player, ItemStack contents) {
        if (!player.hasInfiniteMaterials()) {
            throw new IllegalArgumentException("Player " + String.valueOf(player) + " does not have infinite materials");
        }
        return new InfiniteMaterialsItemAccess(player, ItemResource.of(contents), contents.getCount());
    }

    public static ItemAccess forPlayerCursor(Player player, AbstractContainerMenu menu) {
        return new PlayerItemAccess(PlayerInventoryWrapper.of(player), CarriedSlotWrapper.of(menu));
    }

    public static ItemAccess forPlayerSlot(Player player, int slot) {
        PlayerInventoryWrapper inventoryWrapper = PlayerInventoryWrapper.of(player);
        return new PlayerItemAccess(inventoryWrapper, RangedResourceHandler.ofSingleIndex(inventoryWrapper, slot));
    }

    public static ItemAccess forHandlerIndex(ResourceHandler<ItemResource> handler, int index) {
        return new HandlerItemAccess(handler, index);
    }

    public static ItemAccess forHandlerIndexStrict(ResourceHandler<ItemResource> handler, int index) {
        return new HandlerItemAccess(RangedResourceHandler.ofSingleIndex(handler, index), 0);
    }

    public static ItemAccess forStack(ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Expected stack to be non-empty.");
        }
        return new StackItemAccess(stack);
    }

    @ApiStatus.NonExtendable
    default public ItemAccess oneByOne() {
        return new OneByOneItemAccess(this);
    }

    @Nullable
    @ApiStatus.NonExtendable
    default public <T> T getCapability(ItemCapability<T, ItemAccess> capability) {
        return capability.getCapability(this.getResource().toStack(), this);
    }

    public ItemResource getResource();

    public int getAmount();

    public int insert(ItemResource var1, int var2, TransactionContext var3);

    public int extract(ItemResource var1, int var2, TransactionContext var3);

    @ApiStatus.NonExtendable
    default public int exchange(ItemResource newResource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(newResource, amount);
        ItemResource currentResource = this.getResource();
        TransferPreconditions.checkNonEmpty(currentResource);
        try (Transaction subTransaction = Transaction.open(transaction);){
            int inserted;
            int extracted = this.extract(currentResource, amount, subTransaction);
            if (extracted > 0 && (inserted = this.insert(newResource, extracted, subTransaction)) == extracted) {
                subTransaction.commit();
                int n = extracted;
                return n;
            }
        }
        return 0;
    }
}

