/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.textures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public record NamespacedDirectoryLister(String namespace, String sourcePath, String idPrefix) implements SpriteSource
{
    public static final MapCodec<NamespacedDirectoryLister> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("namespace").forGetter(lister -> lister.namespace), (App)Codec.STRING.fieldOf("source").forGetter(lister -> lister.sourcePath), (App)Codec.STRING.fieldOf("prefix").forGetter(lister -> lister.idPrefix)).apply((Applicative)inst, NamespacedDirectoryLister::new));
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"namespaced_directory");

    public void run(ResourceManager resourceManager, SpriteSource.Output output) {
        FileToIdConverter converter = new FileToIdConverter("textures/" + this.sourcePath, ".png");
        converter.listMatchingResourcesFromNamespace(resourceManager, this.namespace).forEach((path, resource) -> {
            ResourceLocation id = converter.fileToId(path).withPrefix(this.idPrefix);
            output.add(id, resource);
        });
    }

    public MapCodec<? extends SpriteSource> codec() {
        return CODEC;
    }
}

