/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import java.util.List;
import java.util.Map;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public class RegisterRecipeBookSearchCategoriesEvent
extends Event
implements IModBusEvent {
    private final Map<ExtendedRecipeBookCategory, List<RecipeBookCategory>> categories;

    @ApiStatus.Internal
    public RegisterRecipeBookSearchCategoriesEvent(Map<ExtendedRecipeBookCategory, List<RecipeBookCategory>> categories) {
        this.categories = categories;
    }

    public void register(ExtendedRecipeBookCategory searchCategory, RecipeBookCategory ... includedCategories) {
        if (includedCategories.length == 0) {
            throw new IllegalArgumentException("Forgot to register included categories.");
        }
        if (this.categories.containsKey(searchCategory)) {
            throw new IllegalArgumentException("Duplicate registration of search category " + String.valueOf(searchCategory));
        }
        this.categories.put(searchCategory, List.of(includedCategories));
    }
}

