/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.client.gui.components.debug.DebugScreenEntryStatus;
import net.minecraft.client.gui.components.debug.DebugScreenProfile;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class RegisterDebugEntriesEvent
extends Event
implements IModBusEvent {
    private final Map<ResourceLocation, DebugScreenEntry> entries;
    private final Map<ResourceLocation, DebugScreenEntryStatus> defaultProfile;
    private final Map<ResourceLocation, DebugScreenEntryStatus> performanceProfile;

    @ApiStatus.Internal
    public RegisterDebugEntriesEvent(Map<ResourceLocation, DebugScreenEntry> entries, Map<ResourceLocation, DebugScreenEntryStatus> defaultProfile, Map<ResourceLocation, DebugScreenEntryStatus> performanceProfile) {
        this.entries = entries;
        this.defaultProfile = new HashMap<ResourceLocation, DebugScreenEntryStatus>(defaultProfile);
        this.performanceProfile = new HashMap<ResourceLocation, DebugScreenEntryStatus>(performanceProfile);
    }

    public void register(ResourceLocation id, DebugScreenEntry entry) {
        if (this.entries.putIfAbsent(id, entry) != null) {
            throw new IllegalStateException("Duplicate DebugScreenEntry registration: " + String.valueOf(id));
        }
    }

    public boolean isRegistered(ResourceLocation id) {
        return this.entries.containsKey(id);
    }

    public void includeInProfile(ResourceLocation id, DebugScreenProfile profile, DebugScreenEntryStatus profileStatus) {
        if (this.getProfileMap(profile).putIfAbsent(id, profileStatus) != null) {
            throw new IllegalStateException("Duplicate DebugScreenEntry " + profile.getSerializedName() + "-profile inclusion: " + String.valueOf(id));
        }
    }

    public boolean isIncludedInProfile(ResourceLocation id, DebugScreenProfile profile) {
        return this.getProfileMap(profile).containsKey(id);
    }

    private Map<ResourceLocation, DebugScreenEntryStatus> getProfileMap(DebugScreenProfile profile) {
        return switch (profile) {
            default -> throw new MatchException(null, null);
            case DebugScreenProfile.DEFAULT -> this.defaultProfile;
            case DebugScreenProfile.PERFORMANCE -> this.performanceProfile;
        };
    }

    @ApiStatus.Internal
    public Map<DebugScreenProfile, Map<ResourceLocation, DebugScreenEntryStatus>> validateProfiles() {
        IllegalStateException defaultError = this.validateProfile(DebugScreenProfile.DEFAULT);
        IllegalStateException performanceError = this.validateProfile(DebugScreenProfile.PERFORMANCE);
        if (defaultError != null && performanceError != null) {
            IllegalStateException error = new IllegalStateException("Fatal errors occurred while validating DebugScreenProfiles");
            error.addSuppressed(defaultError);
            error.addSuppressed(performanceError);
            throw error;
        }
        if (defaultError != null) {
            throw defaultError;
        }
        if (performanceError != null) {
            throw performanceError;
        }
        return Map.of(DebugScreenProfile.DEFAULT, Map.copyOf(this.defaultProfile), DebugScreenProfile.PERFORMANCE, Map.copyOf(this.performanceProfile));
    }

    @Nullable
    private IllegalStateException validateProfile(DebugScreenProfile profile) {
        Map<ResourceLocation, DebugScreenEntryStatus> profileMap = this.getProfileMap(profile);
        Sets.SetView invalidIds = Sets.difference(profileMap.keySet(), this.entries.keySet());
        if (!invalidIds.isEmpty()) {
            Logger logger = LogUtils.getLogger();
            logger.error("Found {} unregistered debug entries in profile: {}", (Object)invalidIds.size(), (Object)profile.getSerializedName());
            logger.error("Unregistered debug entries: {}", (Object)invalidIds.stream().map(ResourceLocation::toString).collect(Collectors.joining(",", "[", "]")));
            if (!FMLEnvironment.isProduction()) {
                return new IllegalStateException("Fatal error occurred while validating DebugScreenProfile: " + profile.getSerializedName());
            }
        }
        return null;
    }
}

