/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.IdentityHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientCommandSourceStack;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.command.CommandHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class ClientCommandHandler {
    private static final ResourceLocation ASK_SERVER_ID = ResourceLocation.withDefaultNamespace((String)"ask_server");
    private static final Logger LOGGER = LogManager.getLogger();
    private static CommandDispatcher<CommandSourceStack> commands = null;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(ClientCommandHandler::handleClientPlayerLogin);
    }

    private static void handleClientPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientPacketListener connection = event.getPlayer().connection;
        connection.commands = ClientCommandHandler.mergeServerCommands((CommandDispatcher<ClientSuggestionProvider>)new CommandDispatcher(), CommandBuildContext.simple((HolderLookup.Provider)connection.registryAccess(), (FeatureFlagSet)connection.enabledFeatures()));
    }

    @ApiStatus.Internal
    public static CommandDispatcher<ClientSuggestionProvider> mergeServerCommands(CommandDispatcher<ClientSuggestionProvider> serverCommands, CommandBuildContext buildContext) {
        CommandDispatcher commandsTemp = new CommandDispatcher();
        NeoForge.EVENT_BUS.post((Event)new RegisterClientCommandsEvent((CommandDispatcher<CommandSourceStack>)commandsTemp, buildContext));
        commands = new CommandDispatcher();
        ClientCommandHandler.copy(commandsTemp.getRoot(), commands.getRoot());
        RootCommandNode serverCommandsRoot = serverCommands.getRoot();
        CommandDispatcher newServerCommands = new CommandDispatcher();
        ClientCommandHandler.copy(serverCommandsRoot, newServerCommands.getRoot());
        CommandHelper.mergeCommandNode(commands.getRoot(), newServerCommands.getRoot(), new IdentityHashMap(), ClientCommandHandler.getSource(), context -> 0, suggestions -> {
            ResourceLocation id = SuggestionProviders.getName((SuggestionProvider)suggestions);
            SuggestionProvider suggestionProvider = id.equals((Object)ASK_SERVER_ID) ? (context, builder) -> {
                ClientCommandSourceStack source = ClientCommandHandler.getSource();
                StringReader reader = new StringReader(context.getInput());
                if (reader.canRead() && reader.peek() == '/') {
                    reader.skip();
                }
                ParseResults parse = commands.parse(reader, (Object)source);
                return commands.getCompletionSuggestions(parse);
            } : SuggestionProviders.getProvider((ResourceLocation)id);
            return suggestionProvider;
        });
        return newServerCommands;
    }

    public static CommandDispatcher<CommandSourceStack> getDispatcher() {
        return commands;
    }

    public static ClientCommandSourceStack getSource() {
        LocalPlayer player = Minecraft.getInstance().player;
        CommandSource commandSource = new CommandSource(){

            public boolean acceptsSuccess() {
                return true;
            }

            public boolean acceptsFailure() {
                return true;
            }

            public boolean shouldInformAdmins() {
                return true;
            }

            public void sendSystemMessage(Component message) {
                Minecraft.getInstance().gui.getChat().addMessage(message);
            }
        };
        return new ClientCommandSourceStack(commandSource, player.position(), player.getRotationVector(), player.getPermissionLevel(), player.getName().getString(), player.getDisplayName(), (Entity)player);
    }

    private static <S> void copy(CommandNode<S> sourceNode, CommandNode<S> resultNode) {
        IdentityHashMap<Object, Object> newNodes = new IdentityHashMap<Object, Object>();
        newNodes.put(sourceNode, resultNode);
        for (CommandNode child : sourceNode.getChildren()) {
            CommandNode copy = newNodes.computeIfAbsent(child, innerChild -> {
                ArgumentBuilder builder = innerChild.createBuilder();
                CommandNode innerCopy = builder.build();
                ClientCommandHandler.copy(innerChild, innerCopy);
                return innerCopy;
            });
            resultNode.addChild(copy);
        }
    }

    public static boolean runCommand(String command) {
        StringReader reader = new StringReader(command);
        ClientCommandSourceStack source = ClientCommandHandler.getSource();
        try {
            commands.execute(reader, (Object)source);
        }
        catch (CommandSyntaxException syntax) {
            if (syntax.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand() || syntax.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument()) {
                return false;
            }
            Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)"").append(ComponentUtils.fromMessage((Message)syntax.getRawMessage())).withStyle(ChatFormatting.RED));
            if (syntax.getInput() != null && syntax.getCursor() >= 0) {
                int position = Math.min(syntax.getInput().length(), syntax.getCursor());
                MutableComponent details = Component.literal((String)"").withStyle(ChatFormatting.GRAY).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand(reader.getString())));
                if (position > 10) {
                    details.append("...");
                }
                details.append(syntax.getInput().substring(Math.max(0, position - 10), position));
                if (position < syntax.getInput().length()) {
                    details.append((Component)Component.literal((String)syntax.getInput().substring(position)).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE}));
                }
                details.append((Component)Component.translatable((String)"command.context.here").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)"").append((Component)details).withStyle(ChatFormatting.RED));
            }
        }
        catch (Exception generic) {
            MutableComponent message = Component.literal((String)(generic.getMessage() == null ? generic.getClass().getName() : generic.getMessage()));
            Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)"command.failed").withStyle(ChatFormatting.RED).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)message))));
            LOGGER.error("Error executing client command \"{}\"", (Object)command, (Object)generic);
        }
        return true;
    }
}

