/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.lighting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class QuadLighter {
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f};
    private final BlockColors colors;
    private int currentHash = 0;
    private BlockAndTintGetter level;
    private BlockPos pos;
    private BlockState state;
    private int cachedTintIndex = -1;
    private final float[] cachedTintColor = new float[3];
    private final float[] brightness = new float[4];
    private final int[] lightmap = new int[4];
    private final float[][] positions = new float[4][3];
    private final byte[][] normals = new byte[4][3];
    private final int[] packedLightmaps = new int[4];
    private final float[] adjustedPosition = new float[3];
    private final Vector3f a = new Vector3f();
    private final Vector3f ab = new Vector3f();
    private final Vector3f ac = new Vector3f();

    protected QuadLighter(BlockColors colors) {
        this.colors = colors;
    }

    protected abstract void computeLightingAt(BlockAndTintGetter var1, BlockPos var2, BlockState var3);

    protected abstract float calculateBrightness(float[] var1);

    protected abstract int calculateLightmap(float[] var1, byte[] var2);

    public final void setup(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        int hash = Objects.hash(level, pos, state);
        if (this.level != null && this.currentHash == hash) {
            return;
        }
        this.currentHash = hash;
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.cachedTintIndex = -1;
        this.computeLightingAt(level, pos, state);
    }

    public final void reset() {
        this.level = null;
    }

    public final void computeLightingForQuad(BakedQuad quad) {
        int i;
        int[] vertices = quad.getVertices();
        for (i = 0; i < 4; ++i) {
            int offset = i * IQuadTransformer.STRIDE;
            this.positions[i][0] = Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION]);
            this.positions[i][1] = Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 1]);
            this.positions[i][2] = Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 2]);
            int packedNormal = vertices[offset + IQuadTransformer.NORMAL];
            this.normals[i][0] = (byte)(packedNormal & 0xFF);
            this.normals[i][1] = (byte)(packedNormal >> 8 & 0xFF);
            this.normals[i][2] = (byte)(packedNormal >> 16 & 0xFF);
            this.packedLightmaps[i] = vertices[offset + IQuadTransformer.UV2];
        }
        if (this.normals[0][0] == 0 && this.normals[0][1] == 0 && this.normals[0][2] == 0) {
            this.a.set(this.positions[0]);
            this.ab.set(this.positions[1]);
            this.ac.set(this.positions[2]);
            this.ac.sub((Vector3fc)this.a);
            this.ab.sub((Vector3fc)this.a);
            this.ab.cross((Vector3fc)this.ac);
            this.ab.normalize();
            for (int v = 0; v < 4; ++v) {
                this.normals[v][0] = (byte)(this.ab.x() * 127.0f);
                this.normals[v][1] = (byte)(this.ab.y() * 127.0f);
                this.normals[v][2] = (byte)(this.ab.z() * 127.0f);
            }
        }
        for (i = 0; i < 4; ++i) {
            float[] position = this.positions[i];
            byte[] normal = this.normals[i];
            int packedLightmap = this.packedLightmaps[i];
            this.adjustedPosition[0] = position[0] - 0.5f + (float)normal[0] / 127.0f * 0.5f;
            this.adjustedPosition[1] = position[1] - 0.5f + (float)normal[1] / 127.0f * 0.5f;
            this.adjustedPosition[2] = position[2] - 0.5f + (float)normal[2] / 127.0f * 0.5f;
            float shade = this.level.getShade((float)this.normals[i][0] / 127.0f, (float)this.normals[i][1] / 127.0f, (float)this.normals[i][2] / 127.0f, quad.isShade());
            this.brightness[i] = this.calculateBrightness(this.adjustedPosition) * shade;
            int newLightmap = this.calculateLightmap(this.adjustedPosition, normal);
            this.lightmap[i] = Math.max(packedLightmap & 0xFFFF, newLightmap & 0xFFFF) | Math.max(packedLightmap >> 16 & 0xFFFF, newLightmap >> 16 & 0xFFFF) << 16;
        }
    }

    public final float[] getComputedBrightness() {
        return this.brightness;
    }

    public final int[] getComputedLightmap() {
        return this.lightmap;
    }

    public final void process(VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quad, int overlay) {
        this.computeLightingForQuad(quad);
        float[] color = quad.isTinted() ? this.getColorFast(quad.getTintIndex()) : WHITE;
        consumer.putBulkData(pose, quad, this.brightness, color[0], color[1], color[2], 1.0f, this.lightmap, overlay, true);
    }

    private float[] getColorFast(int tintIndex) {
        if (tintIndex != this.cachedTintIndex) {
            int packedColor = this.colors.getColor(this.state, this.level, this.pos, tintIndex);
            this.cachedTintIndex = tintIndex;
            this.cachedTintColor[0] = (float)(packedColor >> 16 & 0xFF) / 255.0f;
            this.cachedTintColor[1] = (float)(packedColor >> 8 & 0xFF) / 255.0f;
            this.cachedTintColor[2] = (float)(packedColor & 0xFF) / 255.0f;
        }
        return this.cachedTintColor;
    }

    public static float calculateShade(float normalX, float normalY, float normalZ, boolean constantAmbientLight) {
        float yFactor = constantAmbientLight ? 0.9f : (3.0f + normalY) / 4.0f;
        return Math.min(normalX * normalX * 0.6f + normalY * normalY * yFactor + normalZ * normalZ * 0.8f, 1.0f);
    }
}

