/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.internal;

import java.util.concurrent.Executor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModWorkManager;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.internal.RegistrationEvents;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import net.neoforged.neoforge.registries.GameData;
import net.neoforged.neoforge.registries.RegistryManager;

public abstract class CommonModLoader {
    private static boolean registriesLoaded = false;

    public static boolean areRegistriesLoaded() {
        return registriesLoaded;
    }

    protected static void begin(Runnable periodicTask) {
        Executor syncExecutor = ModWorkManager.syncExecutor();
        ModLoader.gatherAndInitializeMods((Executor)syncExecutor, (Executor)ModWorkManager.parallelExecutor(), (Runnable)periodicTask);
        ModLoader.runInitTask((String)"Registry initialization", (Executor)syncExecutor, (Runnable)periodicTask, () -> {
            RegistryManager.postNewRegistryEvent();
            GameData.unfreezeData();
            GameData.postRegisterEvents();
            GameData.freezeData();
            registriesLoaded = true;
        });
    }

    protected static void load(Executor syncExecutor, Executor parallelExecutor) {
        Runnable periodicTask = () -> {};
        ModLoader.runInitTask((String)"Config loading", (Executor)syncExecutor, (Runnable)periodicTask, () -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get());
            }
            ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, FMLPaths.CONFIGDIR.get());
        });
        ModLoader.dispatchParallelEvent((String)"Common setup", (Executor)syncExecutor, (Executor)parallelExecutor, (Runnable)periodicTask, FMLCommonSetupEvent::new);
        ModLoader.dispatchParallelEvent((String)"Sided setup", (Executor)syncExecutor, (Executor)parallelExecutor, (Runnable)periodicTask, FMLEnvironment.dist.isClient() ? FMLClientSetupEvent::new : FMLDedicatedServerSetupEvent::new);
        ModLoader.runInitTask((String)"Registration events", (Executor)syncExecutor, (Runnable)periodicTask, RegistrationEvents::init);
    }

    protected static void finish(Executor syncExecutor, Executor parallelExecutor) {
        Runnable periodicTask = () -> {};
        ModLoader.dispatchParallelEvent((String)"Enqueue IMC", (Executor)syncExecutor, (Executor)parallelExecutor, (Runnable)periodicTask, InterModEnqueueEvent::new);
        ModLoader.dispatchParallelEvent((String)"Process IMC", (Executor)syncExecutor, (Executor)parallelExecutor, (Runnable)periodicTask, InterModProcessEvent::new);
        ModLoader.dispatchParallelEvent((String)"Complete loading of %d mods".formatted(ModList.get().size()), (Executor)syncExecutor, (Executor)parallelExecutor, (Runnable)periodicTask, FMLLoadCompleteEvent::new);
        ModLoader.runInitTask((String)"Network registry lock", (Executor)syncExecutor, (Runnable)periodicTask, NetworkRegistry::setup);
    }
}

