/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event.entity.player;

import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PlayerRespawnPositionEvent
extends PlayerEvent {
    private DimensionTransition dimensionTransition;
    private final DimensionTransition originalDimensionTransition;
    private final boolean fromEndFight;
    private boolean changePlayerSpawnPosition = true;

    public PlayerRespawnPositionEvent(ServerPlayer player, DimensionTransition dimensionTransition, boolean fromEndFight) {
        super((Player)player);
        this.dimensionTransition = dimensionTransition;
        this.originalDimensionTransition = dimensionTransition;
        this.fromEndFight = fromEndFight;
    }

    public DimensionTransition getDimensionTransition() {
        return this.dimensionTransition;
    }

    public void setDimensionTransition(DimensionTransition dimensionTransition) {
        this.dimensionTransition = dimensionTransition;
    }

    public void setRespawnLevel(ResourceKey<Level> respawnLevelResourceKey) {
        MinecraftServer server = Objects.requireNonNull(this.getEntity().getServer(), "The player is not in a ServerLevel somehow?");
        ServerLevel level = Objects.requireNonNull(server.getLevel(respawnLevelResourceKey), "Level " + String.valueOf(respawnLevelResourceKey) + " does not exist!");
        DimensionTransition dt = this.getDimensionTransition();
        this.setDimensionTransition(new DimensionTransition(level, dt.pos(), dt.speed(), dt.yRot(), dt.xRot(), dt.postDimensionTransition()));
    }

    public DimensionTransition getOriginalDimensionTransition() {
        return this.originalDimensionTransition;
    }

    public boolean changePlayerSpawnPosition() {
        return this.changePlayerSpawnPosition;
    }

    public void setChangePlayerSpawnPosition(boolean changePlayerSpawnPosition) {
        this.changePlayerSpawnPosition = changePlayerSpawnPosition;
    }

    public boolean isFromEndFight() {
        return this.fromEndFight;
    }
}

