/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event.entity.player;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PlayerRespawnPositionEvent
extends PlayerEvent {
    private ServerLevel respawnLevel;
    @Nullable
    private Vec3 respawnPosition;
    private float respawnAngle;
    private final ServerLevel originalRespawnLevel;
    @Nullable
    private final Vec3 originalRespawnPosition;
    private final float originalRespawnAngle;
    private final boolean fromEndFight;
    private boolean changePlayerSpawnPosition = true;

    public PlayerRespawnPositionEvent(ServerPlayer player, ServerLevel respawnLevel, float respawnAngle, @Nullable Vec3 respawnPosition, boolean fromEndFight) {
        super((Player)player);
        this.respawnLevel = respawnLevel;
        this.respawnPosition = respawnPosition;
        this.respawnAngle = respawnAngle;
        this.originalRespawnLevel = respawnLevel;
        this.originalRespawnPosition = respawnPosition;
        this.originalRespawnAngle = respawnAngle;
        this.fromEndFight = fromEndFight;
    }

    public ServerLevel getRespawnLevel() {
        return this.respawnLevel;
    }

    public void setRespawnLevel(ServerLevel respawnLevel) {
        this.respawnLevel = respawnLevel;
    }

    public void setRespawnLevel(ResourceKey<Level> respawnLevelResourceKey) {
        MinecraftServer server = Objects.requireNonNull(this.getEntity().getServer(), "The player is not in a ServerLevel somehow?");
        ServerLevel level = Objects.requireNonNull(server.getLevel(respawnLevelResourceKey), "Level " + String.valueOf(respawnLevelResourceKey) + " does not exist!");
        this.setRespawnLevel(level);
    }

    public ServerLevel getOriginalRespawnLevel() {
        return this.originalRespawnLevel;
    }

    @Nullable
    public Vec3 getRespawnPosition() {
        return this.respawnPosition;
    }

    public void setRespawnPosition(@Nullable Vec3 respawnPosition) {
        this.respawnPosition = respawnPosition;
    }

    @Nullable
    public Vec3 getOriginalRespawnPosition() {
        return this.originalRespawnPosition;
    }

    public float getRespawnAngle() {
        return this.respawnAngle;
    }

    public void setRespawnAngle(float respawnAngle) {
        this.respawnAngle = respawnAngle;
    }

    public float getOriginalRespawnAngle() {
        return this.originalRespawnAngle;
    }

    public boolean changePlayerSpawnPosition() {
        return this.changePlayerSpawnPosition;
    }

    public void setChangePlayerSpawnPosition(boolean changePlayerSpawnPosition) {
        this.changePlayerSpawnPosition = changePlayerSpawnPosition;
    }

    public boolean isFromEndFight() {
        return this.fromEndFight;
    }
}

