/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.IModBusEvent;

public class AddPackFindersEvent
extends Event
implements IModBusEvent {
    private final PackType packType;
    private final Consumer<RepositorySource> sources;

    public AddPackFindersEvent(PackType packType, Consumer<RepositorySource> sources) {
        this.packType = packType;
        this.sources = sources;
    }

    public void addRepositorySource(RepositorySource source) {
        this.sources.accept(source);
    }

    public PackType getPackType() {
        return this.packType;
    }

    public void addPackFinders(ResourceLocation packLocation, PackType packType, Component packNameDisplay, PackSource packSource, boolean alwaysActive, Pack.Position packPosition) {
        if (this.getPackType() == packType) {
            Path resourcePath = ModList.get().getModFileById(packLocation.getNamespace()).getFile().findResource(new String[]{packLocation.getPath()});
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("mod/" + String.valueOf(packLocation), packNameDisplay, packSource, Optional.empty()), (Pack.ResourcesSupplier)BuiltInPackSource.fromName(path -> new PathPackResources(path, resourcePath)), (PackType)packType, (PackSelectionConfig)new PackSelectionConfig(alwaysActive, packPosition, false));
            this.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }
}

