/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.world.chunk;

import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.neoforged.neoforge.common.world.chunk.ForcedChunkManager;
import net.neoforged.neoforge.common.world.chunk.TicketSet;

public class TicketHelper {
    private final Map<BlockPos, TicketSet> blockTickets;
    private final Map<UUID, TicketSet> entityTickets;
    private final ForcedChunksSavedData saveData;
    private final ResourceLocation controllerId;

    TicketHelper(ForcedChunksSavedData saveData, ResourceLocation controllerId, Map<BlockPos, TicketSet> blockTickets, Map<UUID, TicketSet> entityTickets) {
        this.saveData = saveData;
        this.controllerId = controllerId;
        this.blockTickets = blockTickets;
        this.entityTickets = entityTickets;
    }

    public Map<BlockPos, TicketSet> getBlockTickets() {
        return this.blockTickets;
    }

    public Map<UUID, TicketSet> getEntityTickets() {
        return this.entityTickets;
    }

    public void removeAllTickets(BlockPos owner) {
        this.removeAllTickets(this.saveData.getBlockForcedChunks(), owner);
    }

    public void removeAllTickets(UUID owner) {
        this.removeAllTickets(this.saveData.getEntityForcedChunks(), owner);
    }

    private <T extends Comparable<? super T>> void removeAllTickets(ForcedChunkManager.TicketTracker<T> tickets, T owner) {
        ForcedChunkManager.TicketOwner<T> ticketOwner = new ForcedChunkManager.TicketOwner<T>(this.controllerId, owner);
        if (tickets.chunks.containsKey(ticketOwner) || tickets.tickingChunks.containsKey(ticketOwner)) {
            tickets.chunks.remove(ticketOwner);
            tickets.tickingChunks.remove(ticketOwner);
            this.saveData.setDirty(true);
        }
    }

    public void removeTicket(BlockPos owner, long chunk, boolean ticking) {
        this.removeTicket(this.saveData.getBlockForcedChunks(), owner, chunk, ticking);
    }

    public void removeTicket(UUID owner, long chunk, boolean ticking) {
        this.removeTicket(this.saveData.getEntityForcedChunks(), owner, chunk, ticking);
    }

    private <T extends Comparable<? super T>> void removeTicket(ForcedChunkManager.TicketTracker<T> tickets, T owner, long chunk, boolean ticking) {
        if (tickets.remove(new ForcedChunkManager.TicketOwner<T>(this.controllerId, owner), chunk, ticking)) {
            this.saveData.setDirty(true);
        }
    }
}

