/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.model.geometry.GeometryLoaderManager;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.common.util.TransformationHelper;
import org.jetbrains.annotations.Nullable;

public class ExtendedBlockModelDeserializer
extends BlockModel.Deserializer {
    public static final Gson INSTANCE = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new ExtendedBlockModelDeserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).registerTypeAdapter(Transformation.class, (Object)new TransformationHelper.Deserializer()).create();

    public BlockModel deserialize(JsonElement element, Type targetType, JsonDeserializationContext deserializationContext) throws JsonParseException {
        BlockModel model = super.deserialize(element, targetType, deserializationContext);
        JsonObject jsonobject = element.getAsJsonObject();
        IUnbakedGeometry<?> geometry = ExtendedBlockModelDeserializer.deserializeGeometry(deserializationContext, jsonobject);
        List elements = model.getElements();
        if (geometry != null) {
            elements.clear();
            model.customData.setCustomGeometry(geometry);
        }
        if (jsonobject.has("transform")) {
            JsonElement transform = jsonobject.get("transform");
            model.customData.setRootTransform((Transformation)deserializationContext.deserialize(transform, Transformation.class));
        }
        if (jsonobject.has("render_type")) {
            String renderTypeHintName = GsonHelper.getAsString((JsonObject)jsonobject, (String)"render_type");
            model.customData.setRenderTypeHint(new ResourceLocation(renderTypeHintName));
        }
        if (jsonobject.has("visibility")) {
            JsonObject visibility = GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)"visibility");
            for (Map.Entry part : visibility.entrySet()) {
                model.customData.visibilityData.setVisibilityState((String)part.getKey(), ((JsonElement)part.getValue()).getAsBoolean());
            }
        }
        return model;
    }

    @Nullable
    public static IUnbakedGeometry<?> deserializeGeometry(JsonDeserializationContext deserializationContext, JsonObject object) throws JsonParseException {
        boolean optional;
        ResourceLocation name;
        if (!object.has("loader")) {
            return null;
        }
        if (object.get("loader").isJsonObject()) {
            JsonObject loaderObj = object.getAsJsonObject("loader");
            name = new ResourceLocation(GsonHelper.getAsString((JsonObject)loaderObj, (String)"id"));
            optional = GsonHelper.getAsBoolean((JsonObject)loaderObj, (String)"optional", (boolean)false);
        } else {
            name = new ResourceLocation(GsonHelper.getAsString((JsonObject)object, (String)"loader"));
            optional = false;
        }
        IGeometryLoader<?> loader = GeometryLoaderManager.get(name);
        if (loader == null) {
            if (optional) {
                return null;
            }
            throw new JsonParseException(String.format(Locale.ENGLISH, "Model loader '%s' not found. Registered loaders: %s", name, GeometryLoaderManager.getLoaderList()));
        }
        return loader.read(object, deserializationContext);
    }
}

