/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.neoforge.client.command.ClientConfigCommand;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.server.command.EnumArgument;
import net.neoforged.neoforge.server.command.ModIdArgument;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME, modid="neoforge")
public class ConfigCommand {
    @SubscribeEvent
    public static void onClientCommandsRegister(RegisterClientCommandsEvent event) {
        ClientConfigCommand.register(event.getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"config").then(ShowFile.register()));
    }

    public static class ShowFile {
        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"showfile").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"mod", (ArgumentType)ModIdArgument.modIdArgument()).then(Commands.argument((String)"type", EnumArgument.enumArgument(ServerModConfigType.class)).executes(ShowFile::showFile)));
        }

        private static int showFile(CommandContext<CommandSourceStack> context) {
            ModConfig.Type type;
            String modId = (String)context.getArgument("mod", String.class);
            String configFileName = ConfigTracker.INSTANCE.getConfigFileName(modId, type = ModConfig.Type.valueOf((String)((ServerModConfigType)((Object)context.getArgument("type", ServerModConfigType.class))).toString()));
            if (configFileName != null) {
                File f = new File(configFileName);
                MutableComponent fileComponent = Component.literal((String)f.getName()).withStyle(ChatFormatting.UNDERLINE);
                ServerPlayer caller = ((CommandSourceStack)context.getSource()).getPlayer();
                if (FMLLoader.getDist().isClient() && caller != null && caller.connection.connection.isMemoryConnection()) {
                    fileComponent.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getAbsolutePath())));
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.config.getwithtype", (Object[])new Object[]{modId, type.toString(), fileComponent}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.config.noconfig", (Object[])new Object[]{modId, type.toString()}), true);
            }
            return 0;
        }
    }

    public static enum ServerModConfigType {
        COMMON,
        SERVER;


        public String extension() {
            return StringUtils.toLowerCase((String)this.name());
        }
    }
}

