/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.logging;

import cpw.mods.modlauncher.log.TransformingThrowablePatternConverter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import joptsimple.internal.Strings;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.SystemReport;
import net.neoforged.fml.CrashReportCallables;
import net.neoforged.fml.ISystemReportExtender;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.neoforge.forge.snapshots.ForgeSnapshotsMod;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.logging.log4j.Logger;

public class CrashReportExtender {
    public static void extendSystemReport(SystemReport systemReport) {
        for (ISystemReportExtender call : CrashReportCallables.allCrashCallables()) {
            if (!call.isActive()) continue;
            systemReport.setDetail(call.getLabel(), (Supplier)call);
        }
    }

    public static void addCrashReportHeader(StringBuilder stringbuilder, CrashReport crashReport) {
        ForgeSnapshotsMod.addCrashReportHeader(stringbuilder, crashReport);
    }

    public static String generateEnhancedStackTrace(Throwable throwable) {
        return CrashReportExtender.generateEnhancedStackTrace(throwable, true);
    }

    public static String generateEnhancedStackTrace(StackTraceElement[] stacktrace) {
        Throwable t = new Throwable();
        t.setStackTrace(stacktrace);
        return CrashReportExtender.generateEnhancedStackTrace(t, false);
    }

    public static String generateEnhancedStackTrace(Throwable throwable, boolean header) {
        String s = TransformingThrowablePatternConverter.generateEnhancedStackTrace((Throwable)throwable);
        return header ? s : s.substring(s.indexOf(Strings.LINE_SEPARATOR));
    }

    public static File dumpModLoadingCrashReport(Logger logger, List<ModLoadingIssue> issues, File topLevelDir) {
        CrashReport crashReport = CrashReport.forThrowable((Throwable)new Exception("Mod Loading has failed"), (String)"Mod loading error has occurred");
        for (ModLoadingIssue issue : issues) {
            Throwable cause;
            Optional<IModInfo> modInfo = Optional.ofNullable(issue.affectedMod());
            CrashReportCategory category = crashReport.addCategory(modInfo.map(iModInfo -> "MOD " + iModInfo.getModId()).orElse("NO MOD INFO AVAILABLE"));
            int depth = 0;
            for (cause = issue.cause(); cause != null && cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                category.setDetail("Caused by " + depth++, (Object)(String.valueOf(cause) + CrashReportExtender.generateEnhancedStackTrace(cause.getStackTrace()).replaceAll(Strings.LINE_SEPARATOR + "\t", "\n\t\t")));
            }
            if (cause != null) {
                category.applyStackTrace(cause);
            }
            category.setDetail("Mod File", () -> modInfo.map(IModInfo::getOwningFile).map(t -> t.getFile().getFilePath().toUri().getPath()).orElse("NO FILE INFO"));
            category.setDetail("Failure message", () -> issue.translationKey().replace("\n", "\n\t\t"));
            for (int i = 0; i < issue.translationArgs().size(); ++i) {
                Object arg = issue.translationArgs().get(i);
                category.setDetail("Failure message arg " + (i + 1), () -> arg.toString().replace("\n", "\n\t\t"));
            }
            category.setDetail("Mod Version", () -> modInfo.map(IModInfo::getVersion).map(Object::toString).orElse("NO MOD INFO AVAILABLE"));
            category.setDetail("Mod Issue URL", () -> modInfo.map(IModInfo::getOwningFile).map(IModFileInfo.class::cast).flatMap(mfi -> mfi.getConfig().getConfigElement(new String[]{"issueTrackerURL"})).orElse("NOT PROVIDED"));
            category.setDetail("Exception message", (Object)Objects.toString(cause, "MISSING EXCEPTION MESSAGE"));
        }
        File file1 = new File(topLevelDir, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-fml.txt");
        if (crashReport.saveToFile(file2)) {
            logger.fatal("Crash report saved to {}", (Object)file2);
        } else {
            logger.fatal("Failed to save crash report");
        }
        System.out.print(crashReport.getFriendlyReport());
        return file2;
    }
}

