/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IConfigurationPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.ConfigurationPayloadHandler;
import net.neoforged.neoforge.network.registration.ConfigurationRegistration;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.network.registration.PayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.PlayPayloadHandler;
import net.neoforged.neoforge.network.registration.PlayRegistration;
import net.neoforged.neoforge.network.registration.RegistrationFailedException;

class ModdedPacketRegistrar
implements IPayloadRegistrar {
    private final String modId;
    private final Map<ResourceLocation, ConfigurationRegistration<?>> configurationPayloads;
    private final Map<ResourceLocation, PlayRegistration<?>> playPayloads;
    private Optional<String> version = Optional.empty();
    private boolean optional = false;
    private boolean valid = true;

    public ModdedPacketRegistrar(String modId) {
        this.modId = modId;
        this.playPayloads = Maps.newHashMap();
        this.configurationPayloads = Maps.newHashMap();
    }

    private ModdedPacketRegistrar(ModdedPacketRegistrar source) {
        this.modId = source.modId;
        this.playPayloads = source.playPayloads;
        this.configurationPayloads = source.configurationPayloads;
        this.version = source.version;
        this.optional = source.optional;
        this.valid = source.valid;
    }

    public Map<ResourceLocation, ConfigurationRegistration<?>> getConfigurationRegistrations() {
        return ImmutableMap.copyOf(this.configurationPayloads);
    }

    public Map<ResourceLocation, PlayRegistration<?>> getPlayRegistrations() {
        return ImmutableMap.copyOf(this.playPayloads);
    }

    @Override
    public <T extends CustomPacketPayload> IPayloadRegistrar play(ResourceLocation id, FriendlyByteBuf.Reader<T> reader, IPlayPayloadHandler<T> handler) {
        this.play(id, new PlayRegistration<T>(reader, handler, this.version, Optional.empty(), this.optional));
        return this;
    }

    @Override
    public <T extends CustomPacketPayload> IPayloadRegistrar configuration(ResourceLocation id, FriendlyByteBuf.Reader<T> reader, IConfigurationPayloadHandler<T> handler) {
        this.configuration(id, new ConfigurationRegistration<T>(reader, handler, this.version, Optional.empty(), this.optional));
        return this;
    }

    @Override
    public <T extends CustomPacketPayload> IPayloadRegistrar play(ResourceLocation id, FriendlyByteBuf.Reader<T> reader, Consumer<IDirectionAwarePayloadHandlerBuilder<T, IPlayPayloadHandler<T>>> handler) {
        PlayPayloadHandler.Builder builder = new PlayPayloadHandler.Builder();
        handler.accept(builder);
        PlayPayloadHandler innerHandler = builder.create();
        this.play(id, new PlayRegistration<T>(reader, innerHandler, this.version, innerHandler.flow(), this.optional));
        return this;
    }

    @Override
    public <T extends CustomPacketPayload> IPayloadRegistrar configuration(ResourceLocation id, FriendlyByteBuf.Reader<T> reader, Consumer<IDirectionAwarePayloadHandlerBuilder<T, IConfigurationPayloadHandler<T>>> handler) {
        ConfigurationPayloadHandler.Builder builder = new ConfigurationPayloadHandler.Builder();
        handler.accept(builder);
        ConfigurationPayloadHandler innerHandler = builder.create();
        this.configuration(id, new ConfigurationRegistration<T>(reader, innerHandler, this.version, innerHandler.flow(), this.optional));
        return this;
    }

    @Override
    public <T extends CustomPacketPayload> IPayloadRegistrar common(ResourceLocation id, FriendlyByteBuf.Reader<T> reader, Consumer<IDirectionAwarePayloadHandlerBuilder<T, IPayloadHandler<T>>> handler) {
        PayloadHandlerBuilder builder = new PayloadHandlerBuilder();
        handler.accept(builder);
        this.configuration(id, reader, builder::handleConfiguration);
        this.play(id, reader, builder::handlePlay);
        return this;
    }

    private void configuration(ResourceLocation id, ConfigurationRegistration<?> registration) {
        this.validatePayload(id, this.configurationPayloads);
        this.configurationPayloads.put(id, registration);
    }

    private void play(ResourceLocation id, PlayRegistration<?> registration) {
        this.validatePayload(id, this.playPayloads);
        this.playPayloads.put(id, registration);
    }

    private void validatePayload(ResourceLocation id, Map<ResourceLocation, ?> payloads) {
        if (!this.valid) {
            throw new RegistrationFailedException(id, this.modId, RegistrationFailedException.Reason.INVALID_REGISTRAR);
        }
        if (payloads.containsKey(id)) {
            throw new RegistrationFailedException(id, this.modId, RegistrationFailedException.Reason.DUPLICATE_ID);
        }
        if (!id.getNamespace().equals(this.modId)) {
            throw new RegistrationFailedException(id, this.modId, RegistrationFailedException.Reason.INVALID_NAMESPACE);
        }
    }

    @Override
    public IPayloadRegistrar versioned(String version) {
        ModdedPacketRegistrar clone = new ModdedPacketRegistrar(this);
        clone.version = Optional.of(version);
        return clone;
    }

    @Override
    public IPayloadRegistrar optional() {
        ModdedPacketRegistrar clone = new ModdedPacketRegistrar(this);
        clone.optional = true;
        return clone;
    }

    public void invalidate() {
        this.valid = false;
    }
}

