/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IConfigurationPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class PayloadHandlerBuilder<T extends CustomPacketPayload>
implements IDirectionAwarePayloadHandlerBuilder<T, IPayloadHandler<T>> {
    @Nullable
    private IPayloadHandler<T> clientSide;
    @Nullable
    private IPayloadHandler<T> serverSide;

    PayloadHandlerBuilder() {
    }

    public PayloadHandlerBuilder<T> client(IPayloadHandler<T> clientSide) {
        this.clientSide = clientSide;
        return this;
    }

    public PayloadHandlerBuilder<T> server(IPayloadHandler<T> serverSide) {
        this.serverSide = serverSide;
        return this;
    }

    void handlePlay(IDirectionAwarePayloadHandlerBuilder<T, IPlayPayloadHandler<T>> play) {
        if (this.clientSide != null) {
            play.client(this.clientSide::handle);
        }
        if (this.serverSide != null) {
            play.server(this.serverSide::handle);
        }
    }

    void handleConfiguration(IDirectionAwarePayloadHandlerBuilder<T, IConfigurationPayloadHandler<T>> configuration) {
        if (this.clientSide != null) {
            configuration.client(this.clientSide::handle);
        }
        if (this.serverSide != null) {
            configuration.server(this.serverSide::handle);
        }
    }
}

