/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.ParrotImitation;
import net.neoforged.neoforge.registries.datamaps.builtin.RaidHeroGift;
import net.neoforged.neoforge.registries.datamaps.builtin.VibrationFrequency;

public class NeoForgeDataMapsProvider
extends DataMapProvider {
    public NeoForgeDataMapsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @Override
    protected void gather() {
        DataMapProvider.Builder<Compostable, Item> compostables = this.builder(NeoForgeDataMaps.COMPOSTABLES);
        ComposterBlock.COMPOSTABLES.forEach((item, chance) -> compostables.add((Holder<Item>)item.asItem().builtInRegistryHolder(), new Compostable(chance.floatValue()), false, new ICondition[0]));
        DataMapProvider.Builder<FurnaceFuel, Item> fuels = this.builder(NeoForgeDataMaps.FURNACE_FUELS);
        AbstractFurnaceBlockEntity.buildFuels((value, time) -> value.ifLeft(item -> fuels.add((Holder<Item>)item.builtInRegistryHolder(), new FurnaceFuel(time), false, new ICondition[0])).ifRight(tag -> fuels.add((TagKey<Item>)tag, new FurnaceFuel(time), false, new ICondition[0])));
        fuels.remove((TagKey<Item>)ItemTags.NON_FLAMMABLE_WOOD);
        DataMapProvider.Builder<VibrationFrequency, GameEvent> vibrationFrequencies = this.builder(NeoForgeDataMaps.VIBRATION_FREQUENCIES);
        ((Object2IntMap)VibrationSystem.VIBRATION_FREQUENCY_FOR_EVENT).forEach((event, frequency) -> vibrationFrequencies.add((Holder<GameEvent>)event.builtInRegistryHolder(), new VibrationFrequency((int)frequency), false, new ICondition[0]));
        DataMapProvider.Builder<ParrotImitation, EntityType<?>> imitations = this.builder(NeoForgeDataMaps.PARROT_IMITATIONS);
        ((Map)ObfuscationReflectionHelper.getPrivateValue(Parrot.class, null, (String)"MOB_SOUND_MAP")).forEach((type, sound) -> imitations.add((Holder<EntityType<?>>)type.builtInRegistryHolder(), new ParrotImitation((SoundEvent)sound), false, new ICondition[0]));
        DataMapProvider.Builder<RaidHeroGift, VillagerProfession> raidHeroGifts = this.builder(NeoForgeDataMaps.RAID_HERO_GIFTS);
        ((Map)ObfuscationReflectionHelper.getPrivateValue(GiveGiftToHero.class, null, (String)"GIFTS")).forEach((type, lootTable) -> raidHeroGifts.add(BuiltInRegistries.VILLAGER_PROFESSION.wrapAsHolder(type), new RaidHeroGift((ResourceLocation)lootTable), false, new ICondition[0]));
    }
}

