/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.data;

import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MultipartModelData {
    @Deprecated(forRemoval=true)
    public static final ModelProperty<MultipartModelData> PROPERTY = new ModelProperty();
    private final Map<BakedModel, ModelData> partData;

    private MultipartModelData(Map<BakedModel, ModelData> partData) {
        this.partData = partData;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public ModelData get(BakedModel model) {
        return this.partData.get(model);
    }

    public static ModelData resolve(ModelData modelData, BakedModel model) {
        MultipartModelData multipartData = modelData.get(PROPERTY);
        if (multipartData == null) {
            return modelData;
        }
        ModelData partData = multipartData.get(model);
        return partData != null ? partData : modelData;
    }

    public static ModelData create(List<Pair<Predicate<BlockState>, BakedModel>> selectors, BitSet bitset, BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData tileModelData) {
        IdentityHashMap<BakedModel, ModelData> dataMap = null;
        for (int i = 0; i < bitset.length(); ++i) {
            BakedModel model;
            ModelData data;
            if (!bitset.get(i) || (data = (model = (BakedModel)selectors.get(i).getRight()).getModelData(level, pos, state, tileModelData)) == tileModelData) continue;
            if (dataMap == null) {
                dataMap = new IdentityHashMap<BakedModel, ModelData>();
            }
            dataMap.put(model, data);
        }
        return dataMap == null ? tileModelData : tileModelData.derive().with(PROPERTY, new MultipartModelData(dataMap)).build();
    }

    @Deprecated(forRemoval=true)
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(forRemoval=true)
    public static final class Builder {
        private final Map<BakedModel, ModelData> partData = new IdentityHashMap<BakedModel, ModelData>();

        public Builder with(BakedModel model, ModelData data) {
            this.partData.put(model, data);
            return this;
        }

        public MultipartModelData build() {
            return new MultipartModelData(this.partData);
        }
    }
}

