/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="neoforge")
@ApiStatus.Internal
public final class AttachmentInternals {
    private static final String EMPTY_TAG_KEY = "neoforge:empty";

    @Nullable
    public static CompoundTag addAttachmentsToTag(@Nullable CompoundTag tag, ItemStack stack, boolean fullCopy) {
        CompoundTag attachmentsTag = stack.serializeAttachments();
        if (attachmentsTag != null) {
            if (tag == null) {
                tag = new CompoundTag();
            } else if ((tag = tag.copy()).isEmpty()) {
                tag.putBoolean(EMPTY_TAG_KEY, true);
            }
            tag.put("neoforge:attachments", (Tag)attachmentsTag);
        } else if (fullCopy && tag != null) {
            tag = tag.copy();
        }
        return tag;
    }

    public static ItemStack reconstructItemStack(Item item, int count, @Nullable CompoundTag tag) {
        ItemStack itemstack;
        if (tag != null && tag.contains("neoforge:attachments", 10)) {
            itemstack = new ItemStack((ItemLike)item, count, tag.getCompound("neoforge:attachments"));
            tag = AttachmentInternals.cleanTag(tag);
        } else {
            itemstack = new ItemStack((ItemLike)item, count);
        }
        itemstack.setTag(tag);
        return itemstack;
    }

    @Nullable
    public static CompoundTag cleanTag(CompoundTag tag) {
        tag.remove("neoforge:attachments");
        if (tag.contains(EMPTY_TAG_KEY)) {
            tag.remove(EMPTY_TAG_KEY);
        } else if (tag.isEmpty()) {
            tag = null;
        }
        return tag;
    }

    private static <H extends AttachmentHolder> void copyAttachments(H from, H to, Predicate<AttachmentType<?>> filter) {
        if (from.attachments == null) {
            return;
        }
        for (Map.Entry<AttachmentType<?>, Object> entry : from.attachments.entrySet()) {
            Object copy;
            AttachmentType<?> type = entry.getKey();
            if (type.serializer == null) continue;
            IAttachmentCopyHandler<Object> copyHandler = type.copyHandler;
            if (!filter.test(type) || (copy = copyHandler.copy(to.getExposedHolder(), entry.getValue())) == null) continue;
            to.getAttachmentMap().put(type, copy);
        }
    }

    public static void copyStackAttachments(ItemStack from, ItemStack to) {
        AttachmentInternals.copyAttachments(from, to, type -> true);
    }

    public static void copyChunkAttachmentsOnPromotion(AttachmentHolder.AsField from, AttachmentHolder.AsField to) {
        AttachmentInternals.copyAttachments(from, to, type -> true);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        AttachmentInternals.copyAttachments(event.getOriginal(), event.getEntity(), event.isWasDeath() ? type -> type.copyOnDeath : type -> true);
    }

    @SubscribeEvent
    public static void onLivingConvert(LivingConversionEvent.Post event) {
        AttachmentInternals.copyAttachments(event.getEntity(), event.getOutcome(), type -> type.copyOnDeath);
    }

    private AttachmentInternals() {
    }
}

