/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.binarypatcher;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lzma.streams.LzmaOutputStream;
import net.neoforged.binarypatcher.ConsoleTool;
import net.neoforged.binarypatcher.Patch;
import net.neoforged.binarypatcher.Util;
import net.neoforged.srgutils.IMappingFile;

public class Generator {
    public static final String EXTENSION = ".lzma";
    private static final byte[] EMPTY_DATA = new byte[0];
    private final Map<String, String> o2m = new HashMap<String, String>();
    private final Map<String, String> m2o = new HashMap<String, String>();
    private final Set<String> patches = new TreeSet<String>();
    private final File output;
    private final List<PatchSet> sets = new ArrayList<PatchSet>();
    private boolean pack200 = false;
    private boolean legacy = false;
    private static OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };

    public Generator(File output) {
        this.output = output;
    }

    public Generator addSet(File clean, File dirty, String prefix) {
        if (!this.sets.isEmpty()) {
            String oldPre = this.sets.get(0).prefix;
            if (oldPre == null || oldPre.isEmpty() || prefix == null || prefix.isEmpty()) {
                throw new IllegalArgumentException("Must specify a prefix when creating multiple patchsets in a single output");
            }
            if (this.sets.stream().map(e -> ((PatchSet)e).prefix).anyMatch(prefix::equals)) {
                throw new IllegalArgumentException("Invalid duplicate prefix " + prefix);
            }
        }
        if (prefix != null && prefix.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty prefix");
        }
        this.sets.add(new PatchSet(clean, dirty, prefix));
        return this;
    }

    public Generator pack200() {
        return this.pack200(true);
    }

    public Generator pack200(boolean value) {
        this.pack200 = value;
        return this;
    }

    public Generator legacy() {
        return this.legacy(true);
    }

    public Generator legacy(boolean value) {
        this.legacy = value;
        return this;
    }

    public void loadMappings(File srg) throws IOException {
        IMappingFile map = IMappingFile.load((File)srg);
        map.getClasses().forEach(cls -> {
            this.o2m.put(cls.getOriginal(), cls.getMapped());
            this.m2o.put(cls.getOriginal(), cls.getMapped());
        });
    }

    public void loadPatches(File root) throws IOException {
        int base = root.getAbsolutePath().length();
        int suffix = ".java.patch".length();
        Files.walk(root.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> p.toAbsolutePath().toString()).filter(p -> p.endsWith(".java.patch")).forEach(path -> {
            String relative = path.substring(base + 1).replace('\\', '/');
            this.patches.add(relative.substring(0, relative.length() - suffix));
        });
    }

    public void create() throws IOException {
        TreeMap<String, byte[]> binpatches = new TreeMap<String, byte[]>();
        for (PatchSet set : this.sets) {
            Map<String, byte[]> tmp = this.gatherPatches(set.clean, set.dirty);
            if (set.prefix == null) {
                binpatches.putAll(tmp);
                continue;
            }
            tmp.forEach((key, value) -> binpatches.put(set.prefix + '/' + key, (byte[])value));
        }
        byte[] data = this.createJar(binpatches);
        if (this.pack200) {
            data = this.pack200(data);
        }
        data = this.lzma(data);
        try (FileOutputStream fos = new FileOutputStream(this.output);){
            fos.write(data);
        }
    }

    private Map<String, byte[]> gatherPatches(File clean, File dirty) throws IOException {
        TreeMap<String, byte[]> binpatches;
        block30: {
            binpatches = new TreeMap<String, byte[]>();
            try (ZipFile zclean = new ZipFile(clean);
                 ZipFile zdirty = new ZipFile(dirty);){
                HashMap entries = new HashMap();
                Collections.list(zclean.entries()).stream().map(e -> e.getName()).filter(e -> e.endsWith(".class")).map(e -> e.substring(0, e.length() - 6)).forEach(e -> {
                    int idx = e.indexOf(36);
                    if (idx != -1) {
                        entries.computeIfAbsent(e.substring(0, idx), k -> new HashSet()).add(e);
                    } else {
                        entries.computeIfAbsent(e, k -> new HashSet()).add(e);
                    }
                });
                Collections.list(zdirty.entries()).stream().map(e -> e.getName()).filter(e -> e.endsWith(".class")).map(e -> e.substring(0, e.length() - 6)).forEach(e -> {
                    int idx = e.indexOf(36);
                    if (idx != -1) {
                        entries.computeIfAbsent(e.substring(0, idx), k -> new HashSet()).add(e);
                    } else {
                        entries.computeIfAbsent(e, k -> new HashSet()).add(e);
                    }
                });
                this.log("Creating patches:");
                this.log("  Clean: " + clean);
                this.log("  Dirty: " + dirty);
                if (this.patches.isEmpty()) {
                    for (String cls : entries.keySet()) {
                        byte[] patch;
                        byte[] dirtyData;
                        String srg = this.m2o.getOrDefault(cls, cls);
                        byte[] cleanData = this.getData(zclean, cls);
                        if (Arrays.equals(cleanData, dirtyData = this.getData(zdirty, cls)) || (patch = this.process(cls, srg, cleanData, dirtyData)) == null) continue;
                        binpatches.put(this.toJarName(srg), patch);
                    }
                    break block30;
                }
                for (String path : this.patches) {
                    String obf = this.o2m.getOrDefault(path, path);
                    if (entries.containsKey(obf)) {
                        for (String cls : (Set)entries.get(obf)) {
                            byte[] patch;
                            byte[] dirtyData;
                            byte[] cleanData;
                            String srg = this.m2o.get(cls);
                            if (srg == null) {
                                int idx = cls.indexOf(36);
                                srg = path + '$' + cls.substring(idx + 1);
                            }
                            if (Arrays.equals(cleanData = this.getData(zclean, cls), dirtyData = this.getData(zdirty, cls)) || (patch = this.process(cls, srg, cleanData, dirtyData)) == null) continue;
                            binpatches.put(this.toJarName(srg), patch);
                        }
                        continue;
                    }
                    this.log("  Failed: no source for patch? " + path + " " + obf);
                }
            }
        }
        return binpatches;
    }

    public String toJarName(String original) {
        return original.replace('/', '.') + ".binpatch";
    }

    private byte[] getData(ZipFile zip, String cls) throws IOException {
        ZipEntry entry = zip.getEntry(cls + ".class");
        return entry == null ? EMPTY_DATA : Util.toByteArray(zip.getInputStream(entry));
    }

    public byte[] createJar(Map<String, byte[]> patches) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JarOutputStream zout = new JarOutputStream(out);){
            zout.setLevel(0);
            for (Map.Entry<String, byte[]> e : patches.entrySet()) {
                ZipEntry entry = new ZipEntry(e.getKey());
                entry.setTime(628041600000L);
                zout.putNextEntry(entry);
                zout.write(e.getValue());
                zout.closeEntry();
            }
        }
        return out.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private byte[] pack200(byte[] data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] lzma(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (LzmaOutputStream lzma = new LzmaOutputStream.Builder((OutputStream)out).useEndMarkerMode(true).build();){
            lzma.write(data);
        }
        byte[] ret = out.toByteArray();
        this.log("LZMA: " + data.length + " -> " + ret.length);
        return ret;
    }

    private byte[] process(String obf, String srg, byte[] clean, byte[] dirty) throws IOException {
        if (srg.equals(obf)) {
            this.log("  Processing " + srg);
        } else {
            this.log("  Processing " + srg + "(" + obf + ")");
        }
        Patch patch = Patch.from(obf, srg, clean, dirty);
        this.log("    Clean: " + Integer.toHexString(patch.checksum(clean)) + " Dirty: " + Integer.toHexString(patch.checksum(dirty)));
        return patch.toBytes(this.legacy);
    }

    private void log(String message) {
        ConsoleTool.log(message);
    }

    private static class PatchSet {
        private final String prefix;
        private final File clean;
        private final File dirty;

        private PatchSet(File clean, File dirty, String prefix) {
            this.clean = clean;
            this.dirty = dirty;
            this.prefix = prefix;
        }
    }
}

