/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.JarContentsBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface JarContents
extends Closeable {
    public Path getPrimaryPath();

    public Optional<URI> findFile(String var1);

    @Nullable
    public InputStream openFile(String var1) throws IOException;

    default public boolean containsFile(String relativePath) throws IOException {
        InputStream stream = this.openFile(relativePath);
        if (stream != null) {
            stream.close();
            return true;
        }
        return false;
    }

    public Manifest getManifest();

    public static JarContents of(Path fileOrFolder) {
        return new JarContentsBuilder().paths(fileOrFolder).build();
    }

    public static JarContents of(Collection<Path> filesOrFolders) {
        return new JarContentsBuilder().paths(filesOrFolders.toArray(new Path[0])).build();
    }
}

