/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.LazyJarMetadata;
import cpw.mods.jarhandling.impl.ModuleDescriptorFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public class ModuleJarMetadata
extends LazyJarMetadata {
    private final byte[] originalDescriptorBytes;
    private final ModuleDescriptor originalDescriptor;
    private final JarContents jar;

    public ModuleJarMetadata(URI uri, JarContents jar) {
        this.jar = jar;
        try {
            this.originalDescriptorBytes = Files.readAllBytes(Path.of(uri));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read module-info.class from " + String.valueOf(uri), e);
        }
        this.originalDescriptor = ModuleDescriptor.read(ByteBuffer.wrap(this.originalDescriptorBytes));
    }

    @Override
    protected ModuleDescriptor computeDescriptor() {
        ModuleDescriptor fullDescriptor = ModuleDescriptor.read(ByteBuffer.wrap(this.originalDescriptorBytes), () -> ModuleDescriptorFactory.scanModulePackages(this.jar));
        if (this.originalDescriptor.isOpen() && this.originalDescriptor.packages().equals(fullDescriptor.packages())) {
            return this.originalDescriptor;
        }
        ModuleDescriptor.Builder builder = ModuleDescriptor.newOpenModule(fullDescriptor.name());
        fullDescriptor.rawVersion().ifPresent(builder::version);
        fullDescriptor.exports().forEach(builder::exports);
        fullDescriptor.provides().forEach(builder::provides);
        fullDescriptor.uses().forEach(builder::uses);
        fullDescriptor.requires().forEach(builder::requires);
        fullDescriptor.mainClass().ifPresent(builder::mainClass);
        builder.packages(fullDescriptor.packages());
        return builder.build();
    }

    @Override
    public String name() {
        return this.originalDescriptor.name();
    }

    @Override
    @Nullable
    public String version() {
        return this.originalDescriptor.rawVersion().orElse(null);
    }
}

