/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.impl.JarContentsImpl;
import cpw.mods.jarhandling.impl.JlsConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModuleDescriptorFactory {
    private ModuleDescriptorFactory() {
    }

    public static void scanAutomaticModule(JarContents jar, ModuleDescriptor.Builder builder, String ... excludedRootDirectories) {
        final Set<String> ignoredRootDirs = Set.of(excludedRootDirectories);
        final Path root = ((JarContentsImpl)jar).filesystem.getRoot();
        final Path metaInfDir = root.resolve("META-INF");
        final Path servicesDir = metaInfDir.resolve("services");
        final HashSet<String> packageNames = new HashSet<String>();
        final ArrayList serviceProviderFiles = new ArrayList();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String relativeDir;
                    String pkg;
                    if (file.startsWith(metaInfDir)) {
                        String serviceName;
                        if (file.startsWith(servicesDir) && JlsConstants.isTypeName(serviceName = file.getFileName().toString())) {
                            serviceProviderFiles.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    if (file.getFileName().toString().endsWith(".class") && !(pkg = (relativeDir = root.relativize(file.getParent()).toString()).replace('/', '.')).isEmpty()) {
                        packageNames.add(pkg);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                    if (path.startsWith(servicesDir) && path.getNameCount() <= servicesDir.getNameCount()) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (path.getNameCount() > 0) {
                        if (!ignoredRootDirs.isEmpty() && ignoredRootDirs.contains(path.getName(0).toString())) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        for (int i = 0; i < path.getNameCount(); ++i) {
                            String segment = path.getName(i).toString();
                            if (JlsConstants.isJavaIdentifier(segment)) continue;
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to scan for packages and services in " + String.valueOf(jar), e);
        }
        builder.packages(packageNames);
        for (Path serviceProviderFile : serviceProviderFiles) {
            try {
                ModuleDescriptorFactory.parseServiceFile(serviceProviderFile, packageNames, builder);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to parse service provider file " + String.valueOf(serviceProviderFile) + " in " + String.valueOf(jar), e);
            }
        }
    }

    private static void parseServiceFile(Path file, Set<String> packageNames, ModuleDescriptor.Builder builder) throws IOException {
        String serviceName = file.getFileName().toString();
        ArrayList<String> providerClasses = new ArrayList<String>();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                int startOfComment = line.indexOf(35);
                if (startOfComment != -1) {
                    line = line.substring(0, startOfComment);
                }
                if ((line = line.trim()).isEmpty()) continue;
                String packageName = JlsConstants.getPackageName(line);
                if (!packageNames.contains(packageName)) {
                    String msg = "Service provider file " + String.valueOf(file) + " contains service that is not in this Jar file: " + line;
                    throw new InvalidModuleDescriptorException(msg);
                }
                providerClasses.add(line);
            }
        }
        if (!providerClasses.isEmpty()) {
            builder.provides(serviceName, providerClasses);
        }
    }

    public static Set<String> scanModulePackages(JarContents jar) {
        final Path root = ((JarContentsImpl)jar).filesystem.getRoot();
        final HashSet packageNames = new HashSet();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String pkg;
                    if (attrs.isRegularFile() && !(pkg = root.relativize(file.getParent()).toString().replace('/', '.')).isEmpty()) {
                        packageNames.add(pkg);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                    if (path.getNameCount() > 0) {
                        for (int i = 0; i < path.getNameCount(); ++i) {
                            String segment = path.getName(i).toString();
                            if (JlsConstants.isJavaIdentifier(segment)) continue;
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return Set.copyOf(packageNames);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to scan for packages in " + String.valueOf(jar), e);
        }
    }
}

