/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.modlauncher.api.ITransformationService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IModFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformerDiscovererConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformerDiscovererConstants.class);
    public static final Set<String> SERVICES = Set.of(ITransformationService.class.getName(), IModFileCandidateLocator.class.getName(), IModFileReader.class.getName(), IDependencyLocator.class.getName(), GraphicsBootstrapper.class.getName(), ImmediateWindowProvider.class.getName());

    private TransformerDiscovererConstants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldLoadInServiceLayer(Collection<Path> paths) {
        JarContents contents = JarContents.of(paths);
        try {
            boolean bl = TransformerDiscovererConstants.shouldLoadInServiceLayer(contents);
            return bl;
        }
        finally {
            try {
                contents.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close JarContents {}", paths, (Object)e);
            }
        }
    }

    public static boolean shouldLoadInServiceLayer(Path path) {
        return TransformerDiscovererConstants.shouldLoadInServiceLayer(List.of(path));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean shouldLoadInServiceLayer(JarContents jarContents) {
        try (InputStream moduleInfoContent = jarContents.openFile("module-info.class");){
            if (moduleInfoContent != null) {
                ModuleDescriptor moduleDescriptor = ModuleDescriptor.read(new BufferedInputStream(moduleInfoContent));
                boolean bl = moduleDescriptor.provides().stream().map(ModuleDescriptor.Provides::service).anyMatch(SERVICES::contains);
                return bl;
            }
        }
        catch (InvalidModuleDescriptorException e) {
            throw new RuntimeException("Invalid module-info.class in " + String.valueOf(jarContents), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read module-info.class from " + String.valueOf(jarContents), e);
        }
        for (String service : SERVICES) {
            String serviceFile = "META-INF/services/" + service;
            try {
                if (!jarContents.containsFile(serviceFile)) continue;
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to check for service-file " + serviceFile + " in " + String.valueOf(jarContents), e);
            }
        }
        return false;
    }
}

