/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.neoforged.fml.loading.ClasspathLocatorUtils;
import net.neoforged.fml.loading.TransformerDiscovererConstants;
import net.neoforged.fml.loading.targets.CommonLaunchHandler;
import org.apache.logging.log4j.LogManager;

public class ClasspathTransformerDiscoverer
implements ITransformerDiscoveryService {
    private final List<Path> legacyClasspath = Arrays.stream(System.getProperty("legacyClassPath", "").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).toList();

    @Override
    public List<NamedPath> candidates(Path gameDirectory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<NamedPath> candidates(Path gameDirectory, String launchTarget) {
        if (launchTarget != null && launchTarget.contains("dev")) {
            return this.scan();
        }
        return List.of();
    }

    private List<NamedPath> scan() {
        try {
            HashSet<NamedPath> result = new HashSet<NamedPath>();
            for (String serviceClass : TransformerDiscovererConstants.SERVICES) {
                this.locateTransformers("META-INF/services/" + serviceClass, result);
            }
            this.scanModClasses(result);
            return new ArrayList<NamedPath>(result);
        }
        catch (IOException e) {
            LogManager.getLogger().error("Error during discovery of transform services from the classpath", (Throwable)e);
            return List.of();
        }
    }

    private void locateTransformers(String resource, Collection<NamedPath> result) throws IOException {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resource);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Path path = ClasspathLocatorUtils.findJarPathFor(resource, url.toString(), url);
            if (this.legacyClasspath.stream().anyMatch(path::equals) || !Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) continue;
            result.add(new NamedPath(path.toUri().toString(), path));
        }
    }

    private void scanModClasses(Collection<NamedPath> result) {
        Map<String, List<Path>> modClassPaths = CommonLaunchHandler.getGroupedModFolders();
        for (Map.Entry<String, List<Path>> entry : modClassPaths.entrySet()) {
            String modid = entry.getKey();
            List<Path> paths = entry.getValue();
            if (!TransformerDiscovererConstants.shouldLoadInServiceLayer(paths)) continue;
            result.add(new NamedPath(modid, (Path[])paths.toArray(Path[]::new)));
        }
    }
}

