/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.api;

import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TargetType;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public interface ITransformer<T> {
    public static final String[] DEFAULT_LABEL = new String[]{"default"};

    public T transform(T var1, ITransformerVotingContext var2);

    public TransformerVoteResult castVote(ITransformerVotingContext var1);

    public Set<Target<T>> targets();

    public TargetType<T> getTargetType();

    default public String[] labels() {
        return DEFAULT_LABEL;
    }

    public record Target<T>(String className, String elementName, String elementDescriptor, TargetType<T> targetType) {
        public static Target<ClassNode> targetClass(String className) {
            return new Target<ClassNode>(className, "", "", TargetType.CLASS);
        }

        public static Target<ClassNode> targetPreClass(String className) {
            return new Target<ClassNode>(className, "", "", TargetType.PRE_CLASS);
        }

        public static Target<MethodNode> targetMethod(String className, String methodName, String methodDescriptor) {
            return new Target<MethodNode>(className, methodName, methodDescriptor, TargetType.METHOD);
        }

        public static Target<FieldNode> targetField(String className, String fieldName) {
            return new Target<FieldNode>(className, fieldName, "", TargetType.FIELD);
        }
    }
}

