/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ApiStatus.Internal
public class NeoForgeDevDistCleaner
implements ILaunchPluginService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker DISTXFORM = MarkerFactory.getMarker((String)"DISTXFORM");
    private static final EnumSet<ILaunchPluginService.Phase> EMPTY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    private Dist dist;
    private final Set<String> maskedClasses = new HashSet<String>();

    @Override
    public String name() {
        return "neoforgedevdistcleaner";
    }

    @Override
    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        if (this.maskedClasses.contains(classType.getClassName())) {
            Object[] objectArray = new Object[2];
            objectArray[0] = classType.getClassName();
            objectArray[1] = switch (this.dist) {
                default -> throw new MatchException(null, null);
                case Dist.CLIENT -> "client";
                case Dist.DEDICATED_SERVER -> "dedicated server";
            };
            String message = String.format("Attempted to load class %s which is not present on the %s", objectArray);
            LOGGER.error(DISTXFORM, message);
            NeoForgeDevDistCleaner.throwUnchecked(new ClassNotFoundException(message));
        }
        return EMPTY;
    }

    private static <T, X extends Throwable> void throwUnchecked(T throwable) throws X {
        throw (Throwable)throwable;
    }

    public synchronized void maskClasses(Collection<String> classes) {
        this.maskedClasses.addAll(classes);
    }

    public void setDistribution(Dist dist) {
        this.dist = Objects.requireNonNull(dist);
    }
}

